% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{get.decluttered}
\alias{get.decluttered}
\title{Get decluttering matrix indicating where to show/hide reference lines}
\usage{
get.decluttered(x = x, n.x = n.x, y = y, n.y = n.y, alpha = 0.05)
}
\arguments{
\item{x}{selections for sample of interest (can be a vector if several samples of interest)}

\item{n.x}{evaluations of \code{x} (can be a vector if several samples of interest)}

\item{y}{selections for comparison (can be a vector if several comparisons will be made)}

\item{n.y}{evaluations of \code{y} (can be a vector if several comparisons of interest)}

\item{alpha}{significance level}
}
\value{
declutter vector in which \code{1} indicates "show" and \code{NA} indicates "hide"
}
\description{
Declutter TCATA curves by hiding reference lines from plots showing TCATA curves.
}
\examples{
# example using 'ojtcata' data set
data(ojtcata)
x <- aggregate(ojtcata[, -c(1:4)], list(samp = ojtcata$samp, attribute = ojtcata$attribute), sum)
p.1.checked <- x[x$samp == 1, -c(1:2)]
p.1.eval <- length(unique(ojtcata$cons))
p.not1.checked <- aggregate(x[, -c(1:2)], list(attribute = x$attribute), sum)[, -1]
p.not1.eval <- length(unique(ojtcata$cons)) * (length(unique(ojtcata$samp)) - 1)

# reference lines for contrast products
p.1.refline <- p.not1.checked / p.not1.eval
# decluttering matrix corresponds to the dimensions of p.1.refline
p.1.declutter <- get.decluttered(x = unlist(p.1.checked), n.x = p.1.eval,
                                        y = unlist(p.not1.checked), n.y = p.not1.eval)
(p.1.declutter <- matrix(p.1.declutter, nrow = nrow(p.1.checked)))
}
\references{
Castura, J. C., Antúnez, L., Giménez, A., Ares, G. (2016). Temporal check-all-that-apply (TCATA): A novel temporal sensory method for characterizing products. \emph{Food Quality and Preference}, 47, 79-90. \url{http://dx.doi.org/10.1016/j.foodqual.2015.06.017}
}
\seealso{
\code{\link[stats]{fisher.test}}
}

