% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tds.R
\encoding{UTF-8}
\name{get.chance}
\alias{get.chance}
\title{TDS chance proportion}
\usage{
get.chance(attributes = c(), include.stop = FALSE)
}
\arguments{
\item{attributes}{number of attributes used in the TDS ballot.}

\item{include.stop}{defaut is \code{FALSE}. Default should be kept if time standardization is applied. Optionally, set to \code{TRUE} if analyzing data on the raw timeline.}
}
\description{
Obtains the TDS chance proportion based on the number of attributes, as proposed by Pineau et al. (2009; Eq. 1).
}
\examples{
# example using 'bars' data set
attributes <- unique(bars$attribute)
chance <- get.chance(attributes)
chance
}
\references{
Pineau, N., Schlich, P., Cordelle, S., Mathonnière, C., Issanchou, S., Imbert, A., Rogeaux, M., Etiévant, P., & Köster, E. (2009). Temporal Dominance of Sensations: Construction of the TDS curves and comparison with time–intensity.  \emph{Food Quality and Preference}, 20, 450–455. \url{http://dx.doi.org/10.1016/j.foodqual.2009.04.005}
}

