#' A subset of the DFLAT gene sets
#'
#' 20 selected gene sets from the DFLAT biological process gene sets
#'
#' @format A list of lists of gene identifiers, indexed by gene set name
#' @source \url{http://bcb.cs.tufts.edu/dflat//}
"dflatExample"

#' A subset of the GSE32472 BPD data set
#'
#' A dataset of 97 normal or BPD samples at 5 days of life, with gestational age, class, and gene expression for 654 genes
#'
#' @format A list
#' \describe{
#'   \item{data}{a matrix of 97 samples and 654 genes}
#'   \item{age}{a list of sample gestational ages, indexed by sample id}
#'   \item{bpd}{a list of statuses, indexed by sample id}
#'   \item{ctrl}{a list of sample ids without BPD}
#'   \item{test}{a list of sample ids with BPD}
#' }
#' @source \url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE32472}
"gse32472Example"

#' TEMPO results for the GSE32472 subset example data set
#'
#' The results data structure generated by tempo.run with default settings on the gse32472Example data set
#'
#' @format A list
#' \describe{
#'   \item{ctrl}{a list of control sample ids used for scoring, identical to gse32472Example$ctrl}
#'   \item{test}{a list of test sample ids used for scoring, identical to gse32472Example$test}
#'   \item{train}{a list of normal sample ids used for model training, identical to gse32472Example$ctrl}
#'   \item{scores}{a data frame of scores and signicance values for each gene set}
#'   \item{pred}{a matrix of age predictions for each sample and gene set}
#'   \item{Y}{age for each sample, identical to gse32472Example$age}
#'   \item{genesets}{the gene sets used in the analysis, identical to dflatExample}
#'   \item{reported}{a list of the gene sets which meet the significance thresholds for reporting}
#' }
"gse32472ExampleTempoResults"
