% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{undoFiberCentering}
\alias{undoFiberCentering}
\title{Postprocessing: Undo fiber Centering}
\usage{
undoFiberCentering(Yn, pre)
}
\arguments{
\item{Yn}{the normalized tensor data. This can be, for example, the output of \code{\link{reconstructTensorBF}}.}

\item{pre}{The centering parameters used for preprocessing in the format as produced by \code{\link{normFiberCentering}}.}
}
\value{
The data tensor after reversing the centering operation.
}
\description{
\code{undoFiberCentering} reverts the fiber's of the \eqn{o^{th}} mode to undo the centering effect.
}
\examples{
#Given tensor Y
\dontrun{Ycentered <- normFiberCentering(Y=Y,o=1)}
\dontrun{Yuncentered <- undoFiberCentering(Ycentered$data,Ycentered$pre)}
}
\references{
Kolda, Tamara G., and Brett W. Bader. "Tensor decompositions and applications." SIAM review 51.3 (2009): 455-500.
}

