% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor.calculateBIC.R
\name{tensor.calculateBIC}
\alias{tensor.calculateBIC}
\title{Calculate the BIC of clustering result}
\usage{
tensor.calculateBIC(x, clusterobj, method = "L0", apply = "main")
}
\arguments{
\item{x}{a three-dimensional array}

\item{clusterobj}{the return object of label2() or classify2()}

\item{method}{two options: "L0", "L1". Two methods use different penalties, where "L0" indicating L0 penalty, "L1" indicating Lasso penalty.}

\item{apply}{"main": apply in the main formula; "cp": apply in the CPD k-means.}
}
\value{
a vector [1]BIC, [2]nonzeromus
}
\description{
Given the clustering result, calculate the BIC.
}
\examples{
x = get.data(20,20,20,2,2,2)$x
clusterobj = classify2(x,2,2,2)
tensor.calculateBIC(x,clusterobj)
}
