% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kneeid.R
\name{kneeid}
\alias{kneeid}
\title{Identify the Knee and Max ECDF Differences for Each Transcript}
\usage{
kneeid(transdflist, expdf, nbcpu = 1, showtime = FALSE, verbose = TRUE)
}
\arguments{
\item{transdflist}{A list of data frames where each data frame contains
transcript data with ECDF values for each condition.}

\item{expdf}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{nbcpu}{An integer specifying the number of CPU cores to use for
parallel computation. The parallelization is performed on the elements of
transdflist. Defaults to 1.}

\item{showtime}{A logical value indicating if the duration of the function
processing should be indicated before ending. Defaults to
\code{FALSE}.}

\item{verbose}{A logical flag indicating whether to print progress messages.
Defaults to \code{TRUE}.}
}
\value{
A data frame where each row corresponds to a transcript and contains
 the coordinates of the knee point and the maximum ECDF difference for each
 condition.
}
\description{
This function identifies the knee point (i.e., point of maximum change) and
the maximum difference in the empirical cumulative distribution function
(ECDF) for each transcript, across different experimental conditions.
}
\examples{
exppath <-  system.file("extdata", "exptab.csv", package="tepr")
transpath <- system.file("extdata", "cugusi_6.tsv", package="tepr")
expthres <- 0.1

## Calculating necessary results
expdf <- read.csv(exppath)
transdf <- read.delim(transpath, header = FALSE)
avfilt <- averageandfilterexprs(expdf, transdf, expthres,
        showtime = FALSE, verbose = FALSE)
ecdf <- genesECDF(avfilt, expdf, verbose = FALSE)
resecdf <- ecdf[[1]]
nbwindows <- ecdf[[2]]
meandiff <- meandifference(resecdf, expdf, nbwindows,
    verbose = FALSE)
bytranslistmean <- split(meandiff, factor(meandiff$transcript))

## Testing kneeid
reskneeid <- kneeid(bytranslistmean, expdf, verbose = FALSE)

}
