% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaplan_meier_plot.R
\name{h_ggkm}
\alias{h_ggkm}
\title{Helper function: KM plot}
\usage{
h_ggkm(
  data,
  xticks = NULL,
  yval = "Survival",
  censor_show,
  xlab,
  ylab,
  ylim = NULL,
  title,
  footnotes = NULL,
  max_time = NULL,
  lwd = 1,
  lty = NULL,
  pch = 3,
  size = 2,
  col = NULL,
  ci_ribbon = FALSE,
  ggtheme = nestcolor::theme_nest()
)
}
\arguments{
\item{data}{(\code{data.frame})\cr survival data as pre-processed by \code{h_data_plot}.}

\item{xticks}{(\code{numeric}, \code{number}, or \code{NULL})\cr numeric vector of ticks or single number with spacing
between ticks on the x axis. If \code{NULL} (default), \code{\link[labeling:extended]{labeling::extended()}} is used to determine
an optimal tick position on the x axis.}

\item{yval}{(\code{string})\cr value of y-axis. Options are \code{Survival} (default) and \code{Failure} probability.}

\item{censor_show}{(\code{flag})\cr whether to show censored.}

\item{xlab}{(\code{string})\cr label of x-axis.}

\item{ylab}{(\code{string})\cr label of y-axis.}

\item{ylim}{(\code{vector} of \code{numeric})\cr vector of length 2 containing lower and upper limits for the y-axis.
If \code{NULL} (default), the minimum and maximum y-values displayed are used as limits.}

\item{title}{(\code{string})\cr title for plot.}

\item{footnotes}{(\code{string})\cr footnotes for plot.}

\item{max_time}{(\code{numeric})\cr maximum value to show on X axis. Only data values less than or up to
this threshold value will be plotted (defaults to \code{NULL}).}

\item{lwd}{(\code{numeric})\cr line width. Length of a vector should be equal
to number of strata from \code{\link[survival:survfit]{survival::survfit()}}.}

\item{lty}{(\code{numeric})\cr line type. Length of a vector should be equal
to number of strata from \code{\link[survival:survfit]{survival::survfit()}}.}

\item{pch}{(\code{numeric}, \code{string})\cr value or character of points symbol to indicate censored cases.}

\item{size}{(\code{numeric})\cr size of censored point, a class of \code{unit}.}

\item{col}{(\code{character})\cr lines colors. Length of a vector should be equal
to number of strata from \code{\link[survival:survfit]{survival::survfit()}}.}

\item{ci_ribbon}{(\code{flag})\cr draw the confidence interval around the Kaplan-Meier curve.}

\item{ggtheme}{(\code{theme})\cr a graphical theme as provided by \code{ggplot2} to control outlook of the Kaplan-Meier curve.}
}
\value{
A \code{ggplot} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Draw the Kaplan-Meier plot using \code{ggplot2}.
}
\examples{
\donttest{
library(dplyr)
library(survival)

fit_km <- tern_ex_adtte \%>\%
  filter(PARAMCD == "OS") \%>\%
  survfit(form = Surv(AVAL, 1 - CNSR) ~ ARMCD, data = .)
data_plot <- h_data_plot(fit_km = fit_km)
xticks <- h_xticks(data = data_plot)
gg <- h_ggkm(
  data = data_plot,
  censor_show = TRUE,
  xticks = xticks,
  xlab = "Days",
  yval = "Survival",
  ylab = "Survival Probability",
  title = "Survival"
)
gg
}

}
