% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_convention.R
\name{argument_convention}
\alias{argument_convention}
\title{Standard arguments}
\arguments{
\item{...}{additional arguments for the lower level functions.}

\item{.aligns}{(\code{character} or \code{NULL})\cr alignment for table contents (not including labels). When \code{NULL},
\code{"center"} is applied. See \code{\link[formatters:list_formats]{formatters::list_valid_aligns()}} for a list of all currently supported alignments.}

\item{.all_col_counts}{(\code{integer})\cr vector where each value represents a global count for a column. Values are
taken from \code{alt_counts_df} if specified (see \code{\link[rtables:build_table]{rtables::build_table()}}).}

\item{.df_row}{(\code{data.frame})\cr data frame across all of the columns for the given row split.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.in_ref_col}{(\code{flag})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.N_col}{(\code{integer(1)})\cr column-wise N (column count) for the full column being analyzed that is typically
passed by \code{rtables}.}

\item{.N_row}{(\code{integer(1)})\cr row-wise N (row group count) for the group of observations being analyzed
(i.e. with no column-based subsetting) that is typically passed by \code{rtables}.}

\item{.ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.stat_names_in}{(\code{character})\cr names of the statistics that are passed directly to name single statistics
(\code{.stats}). This option is visible when producing \code{\link[rtables:data.frame_export]{rtables::as_result_df()}} with \code{make_ard = TRUE}.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{add_total_level}{(\code{flag})\cr adds a "total" level after the others which includes all the levels
that constitute the split. A custom label can be set for this level via the \code{custom_label} argument.}

\item{col_by}{(\code{factor})\cr defining column groups.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{data}{(\code{data.frame})\cr the dataset containing the variables to summarize.}

\item{denom}{(\code{string})\cr choice of denominator for proportion. Options are:
\itemize{
\item \code{n}: number of values in this row and column intersection.
\item \code{N_row}: total number of values in this row across columns.
\item \code{N_col}: total number of values in this column across rows.
}}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{groups_lists}{(named \code{list} of \code{list})\cr optionally contains for each \code{subgroups} variable a
list, which specifies the new group levels via the names and the
levels that belong to it in the character vectors that are elements of the list.}

\item{id}{(\code{string})\cr subject variable name.}

\item{is_event}{(\code{flag})\cr \code{TRUE} if event, \code{FALSE} if time to event is censored.}

\item{label_all}{(\code{string})\cr label for the total population analysis.}

\item{labelstr}{(\code{string})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{method}{(\code{string} or \code{NULL})\cr specifies the test used to calculate the p-value for the difference between
two proportions. For options, see \code{\link[=test_proportion_diff]{test_proportion_diff()}}. Default is \code{NULL} so no test is performed.}

\item{na.rm}{(\code{flag})\cr whether \code{NA} values should be removed from \code{x} prior to analysis.}

\item{na_rm}{(\code{flag})\cr whether \code{NA} values should be removed from \code{x} prior to analysis.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{prune_zero_rows}{(\code{flag})\cr whether to prune all zero rows.}

\item{riskdiff}{(\code{flag})\cr whether a risk difference column is present. When set to \code{TRUE}, \code{\link[=add_riskdiff]{add_riskdiff()}} must be
used as \code{split_fun} in the prior column split of the table layout, specifying which columns should be compared.
See \code{\link[=stat_propdiff_ci]{stat_propdiff_ci()}} for details on risk difference calculation.}

\item{rsp}{(\code{logical})\cr vector indicating whether each subject is a responder or not.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after each group
defined by this split instruction, or \code{NA_character_} (the default) for no section divider.}

\item{table_names}{(\code{character})\cr this can be customized in the case that the same \code{vars} are analyzed multiple
times, to avoid warnings from \code{rtables}.}

\item{tte}{(\code{numeric})\cr vector of time-to-event duration values.}

\item{var_labels}{(\code{character})\cr variable labels.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{var}{(\code{string})\cr single variable name for the primary analysis variable.}

\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{xlim}{(\code{numeric(2)})\cr vector containing lower and upper limits for the x-axis, respectively.
If \code{NULL} (default), the default scale range is used.}

\item{ylim}{(\code{numeric(2)})\cr vector containing lower and upper limits for the y-axis, respectively.
If \code{NULL} (default), the default scale range is used.}
}
\description{
The documentation to this function lists all the arguments in \code{tern}
that are used repeatedly to express an analysis.
}
\details{
Although this function just returns \code{NULL} it has two uses, for
the \code{tern} users it provides a documentation of arguments that are
commonly and consistently used in the framework. For the developer it adds a
single reference point to import the \code{roxygen} argument description with:
\verb{@inheritParams argument_convention}
}
\keyword{internal}
