% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_km.R
\name{control_annot}
\alias{control_annot}
\alias{control_surv_med_annot}
\alias{control_coxph_annot}
\title{Control functions for Kaplan-Meier plot annotation tables}
\usage{
control_surv_med_annot(x = 0.8, y = 0.85, w = 0.32, h = 0.16, fill = TRUE)

control_coxph_annot(
  x = 0.29,
  y = 0.51,
  w = 0.4,
  h = 0.125,
  fill = TRUE,
  ref_lbls = FALSE
)
}
\arguments{
\item{x}{(\code{proportion})\cr x-coordinate for center of annotation table.}

\item{y}{(\code{proportion})\cr y-coordinate for center of annotation table.}

\item{w}{(\code{proportion})\cr relative width of the annotation table.}

\item{h}{(\code{proportion})\cr relative height of the annotation table.}

\item{fill}{(\code{flag} or \code{character})\cr whether the annotation table should have a background fill color.
Can also be a color code to use as the background fill color. If \code{TRUE}, color code defaults to \code{"#00000020"}.}

\item{ref_lbls}{(\code{flag})\cr whether the reference group should be explicitly printed in labels for the
annotation table. If \code{FALSE} (default), only comparison groups will be printed in the table labels.}
}
\value{
A list of components with the same names as the arguments.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Auxiliary functions for controlling arguments for formatting the annotation tables that can be added to plots
generated via \code{\link[=g_km]{g_km()}}.
}
\section{Functions}{
\itemize{
\item \code{control_surv_med_annot()}: Control function for formatting the median survival time annotation table. This annotation
table can be added in \code{\link[=g_km]{g_km()}} by setting \code{annot_surv_med=TRUE}, and can be configured using the
\code{control_surv_med_annot()} function by setting it as the \code{control_annot_surv_med} argument.

\item \code{control_coxph_annot()}: Control function for formatting the Cox-PH annotation table. This annotation table can be
added in \code{\link[=g_km]{g_km()}} by setting \code{annot_coxph=TRUE}, and can be configured using the \code{control_coxph_annot()} function
by setting it as the \code{control_annot_coxph} argument.

}}
\examples{
control_surv_med_annot()

control_coxph_annot()

}
\seealso{
\code{\link[=g_km]{g_km()}}
}
