% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{terrainr_bounding_box}
\alias{terrainr_bounding_box}
\title{Construct a terrainr_bounding_box object}
\usage{
terrainr_bounding_box(bl, tr, coord_units = "degrees")
}
\arguments{
\item{bl, tr}{The bottom left (\code{bl}) and top right (\code{tr}) corners of
the bounding box, either as a \link{terrainr_coordinate_pair} object
or a coordinate pair. If the coordinate pair is not named, it is assumed to
be in (lat, lng) format; if it is named, the function will attempt to
properly identify coordinates.}

\item{coord_units}{Arguments passed to \link{terrainr_coordinate_pair}.
If \code{bl} and \code{tr} are already \link{terrainr_coordinate_pair}
objects, these arguments are not used.}
}
\value{
An object of class \link{terrainr_bounding_box}.
}
\description{
In order to simplify code, most \code{terrainr} functions expect a set S4
class representation of coordinate pairs and bounding boxes. If the provided
data is not in the expected S4 format, these functions are used to cast the
data into the target class.
}
\keyword{internal}
