% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Edges.R
\name{IEdge3}
\alias{IEdge3}
\title{R6 class representing a semi-infinite edge in dimension 3}
\description{
A semi-infinite edge is given by a vertex, its origin,
  and a vector, its direction. Voronoï diagrams possibly have such edges.
}
\examples{

## ------------------------------------------------
## Method `IEdge3$new`
## ------------------------------------------------

iedge <- IEdge3$new(c(1, 1, 1), c(1, 2, 3))
iedge
iedge$O
iedge$O <- c(1, 0, 0)
iedge

## ------------------------------------------------
## Method `IEdge3$print`
## ------------------------------------------------

IEdge3$new(c(2, 0, 0), c(3, -1, 4))
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{O}}{get or set the vertex \code{O}}

\item{\code{direction}}{get or set the vector \code{direction}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IEdge3-new}{\code{IEdge3$new()}}
\item \href{#method-IEdge3-print}{\code{IEdge3$print()}}
\item \href{#method-IEdge3-clone}{\code{IEdge3$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IEdge3-new"></a>}}
\if{latex}{\out{\hypertarget{method-IEdge3-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{IEdge3} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IEdge3$new(O, direction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{O}}{the vertex \code{O} (origin)}

\item{\code{direction}}{the vector \code{direction}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{IEdge3} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{iedge <- IEdge3$new(c(1, 1, 1), c(1, 2, 3))
iedge
iedge$O
iedge$O <- c(1, 0, 0)
iedge
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IEdge3-print"></a>}}
\if{latex}{\out{\hypertarget{method-IEdge3-print}{}}}
\subsection{Method \code{print()}}{
Show instance of an \code{IEdge3} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IEdge3$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{IEdge3$new(c(2, 0, 0), c(3, -1, 4))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IEdge3-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IEdge3-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IEdge3$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
