% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_quadratic_time.R
\name{expect_quadratic_time}
\alias{expect_quadratic_time}
\title{Quadratic Time Complexity Test function}
\usage{
expect_quadratic_time(...)
}
\arguments{
\item{...}{Parameters for the expression to be tested, which is a function of data.sizes, as in asymptoticTimings}
}
\value{
null for expected complexity (quadratic), else throws error.
}
\description{
Function to test if input algorithm has quadratic time complexity
}
\details{
For more information regarding its implementation or functionality/usage, please check https://anirban166.github.io//Testing-functions/
}
\examples{
# Not running since it will throw an expected error of complexity mismatch (for demonstration):
\dontrun{
# Running the quick sort algorithm with sampling against a set of increasing input data sizes:
sizes = 10^seq(1, 3, by = 0.5)
expect_quadratic_time(sort(sample(1:100, data.sizes, replace = TRUE), method = "quick"), sizes)
# The code above will throw an error if the function does not follow a quadratic trend.
}
}
