% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-equality.R
\name{equality-expectations}
\alias{equality-expectations}
\alias{expect_equal}
\alias{expect_setequal}
\alias{expect_equivalent}
\alias{expect_identical}
\alias{expect_identical}
\alias{expect_reference}
\title{Expectation: is the object equal to a value?}
\usage{
expect_equal(object, expected, ..., info = NULL, label = NULL,
  expected.label = NULL)

expect_setequal(object, expected)

expect_equivalent(object, expected, ..., info = NULL, label = NULL,
  expected.label = NULL)

expect_identical(object, expected, info = NULL, label = NULL,
  expected.label = NULL)

expect_identical(object, expected, info = NULL, label = NULL,
  expected.label = NULL)

expect_reference(object, expected, info = NULL, label = NULL,
  expected.label = NULL)
}
\arguments{
\item{object}{object to test}

\item{expected}{Expected value}

\item{...}{other values passed to \code{\link[=all.equal]{all.equal()}}}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{object label. When \code{NULL}, computed from deparsed object.}

\item{expected.label}{Equivalent of \code{label} for shortcut form.}
}
\description{
\itemize{
\item \code{expect_identical} tests with \code{\link[=identical]{identical()}}
\item \code{expect_equal} tests with \code{\link[=all.equal]{all.equal()}}
\item \code{expect_setequal} ignores order and duplicates
\item \code{expect_equivalent} tests with \code{\link[=all.equal]{all.equal()}} and
\code{check.attributes = FALSE}
\item \code{expect_reference} tests if two symbols point to the same underlying
object in memory (requires rlang 1.2.9000 or greater)
}
}
\examples{
a <- 10
expect_equal(a, 10)

# Use expect_equal() when testing for numeric equality
sqrt(2) ^ 2 - 1
expect_equal(sqrt(2) ^ 2, 2)
# Neither of these forms take floating point representation errors into
# account
\dontrun{
expect_true(sqrt(2) ^ 2 == 2)
expect_identical(sqrt(2) ^ 2, 2)
}

# You can pass on additional arguments to all.equal:
\dontrun{
# Test the ABSOLUTE difference is within .002
expect_equal(10.01, 10, tolerance = .002, scale = 1)
}

# Test the RELATIVE difference is within .002
x <- 10
expect_equal(10.01, expected = x, tolerance = 0.002, scale = x)

# expect_equivalent ignores attributes
a <- b <- 1:3
names(b) <- letters[1:3]
expect_equivalent(a, b)
}
\seealso{
Other expectations: \code{\link{comparison-expectations}},
  \code{\link{expect_length}}, \code{\link{expect_match}},
  \code{\link{expect_named}},
  \code{\link{inheritance-expectations}},
  \code{\link{logical-expectations}},
  \code{\link{output-expectations}}
}
