test_that("Package checks", {
  expect_skip(skip_if_not_installed("testthat", "9999.9999.999"))
  expect_skip(skip_if_not_installed("testthat", "1.0.0"), NA)
  expect_skip(skip_if_not(FALSE))
  expect_skip(skip_if(TRUE))
})

test_that("Skip env vars", {
  expect_skip_with_env <- function(new, code, regexp = NULL) {
    withr::with_envvar(new, expect_skip(code, regexp))
  }
  expect_skip_with_env(c("NOT_CRAN" = "false"), skip_on_cran())
  expect_skip_with_env(c("NOT_CRAN" = "true"), skip_on_cran(), NA)

  expect_skip_with_env(c("TRAVIS" = "true"), skip_on_travis())
  expect_skip_with_env(c("TRAVIS" = "false"), skip_on_travis(), NA)

  expect_skip_with_env(c("CI" = "true"), skip_on_ci())
  expect_skip_with_env(c("CI" = "false"), skip_on_ci(), NA)

  expect_skip_with_env(c("APPVEYOR" = "True"), skip_on_appveyor())
  expect_skip_with_env(c("APPVEYOR" = "False"), skip_on_appveyor(), NA)

  expect_skip_with_env(c("R_COVR" = "true"), skip_on_covr())
  expect_skip_with_env(c("R_COVR" = "false"), skip_on_covr(), NA)

  expect_skip_with_env(c("BBS_HOME" = "asdf"), skip_on_bioc())
  expect_skip_with_env(c("BBS_HOME" = ""), skip_on_bioc(), NA)
})

test_that("autogenerated message is always single line", {
  a_very_long_argument_name <- FALSE

  cnd <- capture_condition(skip_if_not(
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name
  ))

  expect_length(cnd$message, 1)
  # ensure the message is not repeated, #1290
  expect_snapshot_output(cat(cnd$message))
})
