% Generated by roxygen2 (4.0.1): do not edit by hand
\name{expect_is_file}
\alias{expect_is_directory}
\alias{expect_is_file}
\title{Return an error if a string represents an existent file.}
\usage{
expect_is_file(potential_filepath, ...)

expect_is_directory(potential_filepath, ...)
}
\arguments{
\item{potential_filepath}{character. The name of the file path to check.}

\item{...}{additional arguments to pass to \code{expect_true}.}
}
\value{
TRUE or FALSE according as \code{potential_filepath} is or is not
  a file.

TRUE or FALSE according as \code{potential_path} is or is not
  a directory.
}
\description{
Return an error if a string represents an existent file.

Return an error if a string represents an existent directory.
}
\examples{
library(testthat)
expect_error(expect_is_file('not/a/file')) # will error
tmp <- tempfile(); writeLines('', tmp)
expect_is_file(tmp) # will not error
\dontrun{
expect_is_directory('not/a/dir') # will error
expect_is_directory(dirname(tempfile())) # will not error
}
}

