% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{engine}
\alias{engine}
\title{support functions for tetragon}
\usage{
engine(df, seq_len, deriv, ci, method, distr, measure_error, n_sim, dates)
}
\arguments{
\item{df}{A data frame with time features on columns}

\item{seq_len}{Positive integer. Time-step number of the projected sequence}

\item{deriv}{Integer vector. Number of differentiation operations to perform for each original time feature. 0 = no change; 1: one diff; 2: two diff.}

\item{ci}{Confidence interval. Default: 0.8}

\item{method}{Positive integer. Distance method for calculating neighbors. Possibile options are: "euclidean", "manhattan", "chebyshev", "sorensen", "gower", "soergel", "kulczynski_d", "canberra", "lorentzian", "intersection", "non-intersection", "wavehedges", "czekanowski", "motyka", "kulczynski_s", "tanimoto", "ruzicka", "inner_product", "harmonic_mean", "cosine", "hassebrook", "jaccard", "dice",  "fidelity",  "bhattacharyya", "squared_chord", "squared_euclidean", "pearson", "neyman", "squared_chi", "prob_symm", "divergence", "clark", "additive_symm", "taneja", "kumar-johnson", "avg".}

\item{distr}{String. DIstribution used to calculate kernel densities. Possible options are: "norm", "cauchy", "logis", "t", "exp".}

\item{measure_error}{Logical. TRUE for measuring validation error. FALSE otherwise.}

\item{n_sim}{String. Sequencing method: deterministic ("segmented"), or non-deterministic ("sampled").}

\item{dates}{Date. Vector with dates for time features.}
}
\description{
support functions for tetragon
}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
