% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tex_preview.R
\name{tex_preview}
\alias{tex_preview}
\title{Render and Preview snippets of TeX in R Viewer}
\usage{
tex_preview(
  obj,
  tex_lines = NULL,
  stem = "tex_temp",
  overwrite = TRUE,
  keep_pdf = FALSE,
  tex_message = FALSE,
  fileDir = tex_opts$get("fileDir"),
  margin = tex_opts$get("margin"),
  imgFormat = tex_opts$get("imgFormat"),
  returnType = tex_opts$get("returnType"),
  resizebox = tex_opts$get("resizebox"),
  usrPackages = tex_opts$get("usrPackages"),
  engine = tex_opts$get("engine"),
  cleanup = tex_opts$get("cleanup"),
  density = tex_opts$get("density"),
  svg_max = tex_opts$get("svg_max"),
  print.xtable.opts = tex_opts$get("print.xtable.opts"),
  opts.html = tex_opts$get("opts.html"),
  markers = interactive(),
  ...
)
}
\arguments{
\item{obj}{object to convert to TeX script}

\item{tex_lines}{vector of character, in case of special needs, instead of
asking texPreview to build up, you may choose to pass in the contents of the
complete LaTeX file directly. It should be a vector of character with each
element as a line of raw TeX code.}

\item{stem}{character, name to use in output files, Default: "tex_temp"}

\item{overwrite}{logical, controls if overwriting of output
stem* files given their existences, Default: TRUE}

\item{keep_pdf}{logical, controls if the rendered pdf file should be kept
or deleted, Default: FALSE}

\item{tex_message}{logical, controls if latex executing messages
are displayed in console. Default: FALSE}

\item{fileDir}{character, output destination. If NULL a temp.dir()
will be used and no output will be saved, Default: tex_opts$get('fileDir')}

\item{margin}{table margin for pdflatex call, Default: tex_opts$get('margin')}

\item{imgFormat}{character, defines the type of image the PDF is
converted to Default: tex_opts$get('imgFormat')}

\item{returnType}{character, one of "viewer", "html", or "tex"
determining appropriate return type for the rendering process,
Default: tex_opts$get('returnType')}

\item{resizebox}{logical, forces a tabular tex object to be constrained on the
margins of the document, Default: tex_opts$get('resizebox')}

\item{usrPackages}{character, vector of usepackage commands,
see details for string format}

\item{engine}{character, specifies which latex to pdf engine to use
('pdflatex','xelatex','lualatex'), Default: tex_opts$get('engine')}

\item{cleanup}{character, vector of file extensions to clean up after
building pdf, Default: tex_opts$get('cleanup')}

\item{density}{numeric, controls the density of the image.
Default is 150: tex_opts$get('density)}

\item{svg_max}{numeric, maximum svg file size allowable to preview,
Default: tex_opts$get('svg_max')}

\item{print.xtable.opts}{list, contains arguments to pass to print.table,
relevant only if xtable is used as the input,
Default: tex_opts$get('print.xtable.opts')}

\item{opts.html}{list, html options, Default: tex_opts$get('opts.html')}

\item{markers}{logical, if TRUE then RStudio markers will be invoked to
create links for the log file on rendering errors, Default: interactive()}

\item{...}{passed to \link[base:system2]{system2}}
}
\value{
The output of the function is dependent on the value of returnType:
\itemize{
\item viewer: NULL
\itemize{
\item magick image is printed in the internal viewer
}
\item tex:
\itemize{
\item character, TeX lines
\item printed 'asis' in RMarkdown
}
\item input: character
\itemize{
\item path to the file containing the tex wrapped in an input call
\item printed 'asis' in RMarkdown
}
\item html: magick image
\itemize{
\item Printed as an HTML document in the internal viewer
\item Printed as an image in RMarkdown
}
}
}
\description{
input TeX script into the function and it renders a pdf and
converts it an image which is sent to Viewer.
}
\details{
\code{tex_preview} is an \verb{S3 method} that can be used to preview TeX output from different
object classes.

Built-in support includes:
\itemize{
\item character (tex lines)
\item knitr_kable (kable/kableExtra)
\item xtable
\item texreg
\item equatiomatic
}

\foldstart{System Requirements}

The function assumes the system has pdflatex installed and it is  defined in the PATH.

\foldend{}

\foldstart{TeX Packages}

To add packages to the tex file on render there are two options
\itemize{
\item Use \link[texPreview:build_usepackage]{build_usepackage} and use the input
argument \code{usrPackages}.
\item Append to the input object \verb{\\\\usepackage\{...\}} calls, they will be parsed
and added the to rendering.
}

\foldend{}

\foldstart{Images}
\itemize{
\item An image file of the name stem with the extension specified in \code{imgFormat}.
\item The default extension is png.
}

\foldend{}

\foldstart{Side effects}
\itemize{
\item The function writes two files to disk in the \code{fileDir}
\itemize{
\item Image file
\item TeX script
}
\item The rendering files are removed up from the \code{fileDir}. This can
be controlled using the \code{cleanup} argument or \code{tex_opts$get('cleanup')}
}

\foldend{}
}
\examples{
data('iris')
if(interactive()){

# Raw TeX

tex <- '\\\\begin{tabular}{llr}
\\\\hline
\\\\multicolumn{2}{c}{Item} \\\\\\\\
\\\\cline{1-2}
Animal    & Description & Price (\\\\$) \\\\\\\\
\\\\hline
Gnat      & per gram    & 13.65      \\\\\\\\
& each        & 0.01       \\\\\\\\
Gnu       & stuffed     & 92.50      \\\\\\\\
Emu       & stuffed     & 33.33      \\\\\\\\
Armadillo & frozen      & 8.99       \\\\\\\\
\\\\hline
\\\\end{tabular}'

# knitr kable

 mtcars\%>\%
   head()\%>\%
   knitr::kable("latex")\%>\%
   tex_preview()

# with svg output pan/zoom is enabled in the internal viewer

tex_preview(obj = tex,stem = 'eq',imgFormat = 'svg')

# use tex_lines parameter to pass full document

tikz_path <- system.file(
                  'examples/tikz/credit_rationing.tex',
                  package = 'texPreview'
                  )

tex_preview(tex_lines = readLines(tikz_path))

}
}
\concept{tex}
