% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{class}
\name{sparse_term_matrix}
\alias{sparse_term_matrix}
\title{Term matrices and statistics ( document-term-matrix, term-document-matrix)}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
# utl <- sparse_term_matrix$new(vector_data = NULL, file_data = NULL,

#                                      document_term_matrix = TRUE)
}
\arguments{
\item{vector_data}{either NULL or a character vector of documents}

\item{file_data}{either NULL or a valid character path to a text file}

\item{document_term_matrix}{either TRUE or FALSE. If TRUE then a document-term-matrix will be returned, otherwise a term-document-matrix}

\item{sort_terms}{either TRUE or FALSE specifying if the initial terms should be sorted ( so that the output sparse matrix is sorted in alphabetical order )}

\item{to_lower}{either TRUE or FALSE. If TRUE the character string will be converted to lower case}

\item{remove_char}{a string specifying the specific characters that should be removed from a text file. If the \emph{remove_char} is "" then no removal of characters take place}

\item{to_upper}{either TRUE or FALSE. If TRUE the character string will be converted to upper case}

\item{utf_locale}{the language specific locale to use in case that either the \emph{to_lower} or the \emph{to_upper} parameter is TRUE and the text file language is other than english. For instance if the language of a text file is greek then the \emph{utf_locale} parameter should be \emph{'el_GR.UTF-8'} ( \emph{language_country.encoding} ). A wrong utf-locale does not raise an error, however the runtime of the function increases.}

\item{remove_punctuation_string}{either TRUE or FALSE. If TRUE then the punctuation of the character string will be removed (applies before the split function)}

\item{remove_punctuation_vector}{either TRUE or FALSE. If TRUE then the punctuation of the vector of the character strings will be removed  (after the string split has taken place)}

\item{remove_numbers}{either TRUE or FALSE. If TRUE then any numbers in the character string will be removed}

\item{trim_token}{either TRUE or FALSE. If TRUE then the string will be trimmed (left and/or right)}

\item{split_string}{either TRUE or FALSE. If TRUE then the character string will be split using the \emph{split_separator} as delimiter. The user can also specify multiple delimiters.}

\item{split_separator}{a character string specifying the character delimiter(s)}

\item{remove_stopwords}{either TRUE, FALSE or a character vector of user defined stop words. If TRUE then by using the \emph{language} parameter the corresponding stop words vector will be uploaded.}

\item{language}{a character string which defaults to english. If the \emph{remove_stopwords} parameter is TRUE then the corresponding stop words vector will be uploaded. Available languages
are \emph{afrikaans}, \emph{arabic}, \emph{armenian}, \emph{basque}, \emph{bengali}, \emph{breton}, \emph{bulgarian}, \emph{catalan},
\emph{croatian}, \emph{czech}, \emph{danish}, \emph{dutch}, \emph{english}, \emph{estonian},
\emph{finnish}, \emph{french}, \emph{galician}, \emph{german}, \emph{greek}, \emph{hausa}, \emph{hebrew}, \emph{hindi}, \emph{hungarian},
\emph{indonesian}, \emph{irish}, \emph{italian}, \emph{latvian}, \emph{marathi},
\emph{norwegian}, \emph{persian}, \emph{polish}, \emph{portuguese}, \emph{romanian}, \emph{russian}, \emph{slovak}, \emph{slovenian},
\emph{somalia}, \emph{spanish}, \emph{swahili}, \emph{swedish}, \emph{turkish}, \emph{yoruba}, \emph{zulu}}

\item{min_num_char}{an integer specifying the minimum number of characters to keep. If the \emph{min_num_char} is greater than 1 then character strings with more than 1 characters will be returned}

\item{max_num_char}{an integer specifying the maximum number of characters to keep. The \emph{max_num_char} should be less than or equal to \emph{Inf} (in this function the Inf value translates to a word-length of 1000000000)}

\item{stemmer}{a character string specifying the stemming method. Available method is the \emph{porter2_stemmer}. See details for more information.}

\item{min_n_gram}{an integer specifying the minimum number of n-grams. The minimum number of min_n_gram is 1.}

\item{max_n_gram}{an integer specifying the maximum number of n-grams. The minimum number of max_n_gram is 1.}

\item{skip_n_gram}{an integer specifying the number of skip-n-grams. The minimum number of skip_n_gram is 1. The skip_n_gram gives the (max.) n-grams using the \emph{skip_distance} parameter. If \emph{skip_n_gram} is greater than 1 then both \emph{min_n_gram} and \emph{max_n_gram} should be set to 1.}

\item{skip_distance}{an integer specifying the skip distance between the words. The minimum value for the skip distance is 0, in which case simple n-grams will be returned.}

\item{n_gram_delimiter}{a character string specifying the n-gram delimiter (applies to both n-gram and skip-n-gram cases)}

\item{print_every_rows}{a numeric value greater than 1 specifying the print intervals. Frequent output in the R session can slow down the function in case of big files.}

\item{normalize}{either NULL or one of 'l1' or 'l2' normalization.}

\item{tf_idf}{either TRUE or FALSE. If TRUE then the term-frequency-inverse-document-frequency will be returned}

\item{threads}{an integer specifying the number of cores to run in parallel}

\item{verbose}{either TRUE or FALSE. If TRUE then information will be printed out}

\item{sparsity_thresh}{a float number between 0.0 and 1.0 specifying the sparsity threshold in the \emph{Term_Matrix_Adjust} function}

\item{Terms}{a character vector specifying the character strings for which the associations will be calculated ( \emph{term_associations} function )}

\item{keep_terms}{either NULL or a numeric value specifying the number of terms to keep ( both in \emph{term_associations} and \emph{most_frequent_terms} functions )}
}
\description{
Term matrices and statistics ( document-term-matrix, term-document-matrix)
}
\details{
the \emph{Term_Matrix} function takes either a character vector of strings or a text file and after tokenization and transformation returns either a document-term-matrix or a term-document-matrix

the \emph{triplet_data} function returns the triplet data, which is used internally (in c++), to construct the Term Matrix. The triplet data could be usefull for secondary purposes, such as in word vector representations.

the \emph{Term_Matrix_Adjust} function removes sparse terms from a sparse matrix using a sparsity threshold

the \emph{term_associations} function finds the associations between the given terms (Terms argument) and all the other terms in the corpus by calculating their correlation. There is also the option to keep a specific number of terms from the output table using the \emph{keep_terms} parameter.

the \emph{most_frequent_terms} function returns the most frequent terms of the corpus using the output of the sparse matrix. The user has the option to keep a specific number of terms from the output table using the \emph{keep_terms} parameter.

Stemming of the english language is done using the porter2-stemmer, for details see \url{https://github.com/smassung/porter2_stemmer}
}
\section{Methods}{


\describe{
 \item{\code{sparse_term_matrix$new(vector_data = NULL, file_data = NULL, document_term_matrix = TRUE)}}{}

 \item{\code{--------------}}{}

 \item{\code{Term_Matrix(sort_terms = FALSE, to_lower = FALSE, to_upper = FALSE, utf_locale = "", remove_char = "", remove_punctuation_string = FALSE, remove_punctuation_vector = FALSE, remove_numbers = FALSE, trim_token = FALSE, split_string = FALSE, split_separator = " .,;:()?!", remove_stopwords = FALSE, language = "english", min_num_char = 1, max_num_char = Inf, stemmer = NULL, min_n_gram = 1, max_n_gram = 1, skip_n_gram = 1, skip_distance = 0, n_gram_delimiter = " ", print_every_rows = 1000, normalize = NULL, tf_idf = FALSE, threads = 1, verbose = FALSE)}}{}

 \item{\code{--------------}}{}

 \item{\code{triplet_data()}}{}

 \item{\code{--------------}}{}

 \item{\code{Term_Matrix_Adjust(sparsity_thresh = 1.0)}}{}

 \item{\code{--------------}}{}

 \item{\code{term_associations(Terms = NULL, keep_terms = NULL, threads = 1, verbose = FALSE)}}{}

 \item{\code{--------------}}{}

 \item{\code{most_frequent_terms(keep_terms = NULL, threads = 1, verbose = FALSE)}}{}
 }
}
\examples{

library(textTinyR)


# sm <- sparse_term_matrix$new(file_data = "/folder/my_data.txt",

#                              document_term_matrix = TRUE)

#--------------
# term matrix :
#--------------

# sm$Term_Matrix(sort_terms = TRUE, to_lower = TRUE,

#                trim_token = TRUE, split_string = TRUE,

#                remove_stopwords = TRUE, normalize = 'l1',

#                stemmer = 'porter2_stemmer', threads = 1 )

#---------------
# triplet data :
#---------------

# sm$triplet_data()

#-------------------------
# removal of sparse terms:
#-------------------------

# sm$Term_Matrix_Adjust(sparsity_thresh = 0.995)


#-----------------------------------------------
# associations between terms of a sparse matrix:
#-----------------------------------------------


# sm$term_associations(Terms = c("word", "sentence"), keep_terms = 10)


#---------------------------------------------
# most frequent terms using the sparse matrix:
#---------------------------------------------


# sm$most_frequent_terms(keep_terms = 10, threads = 1)
}
\keyword{datasets}

