% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{class}
\name{text_intersect}
\alias{text_intersect}
\title{intersection of words or letters in tokenized text}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
# utl <- text_intersect$new(token_list1 = NULL, token_list2 = NULL)
}
\arguments{
\item{token_list1}{a list, where each sublist is a tokenized text sequence (\emph{token_list1} should be of same length with \emph{token_list2})}

\item{token_list2}{a list, where each sublist is a tokenized text sequence (\emph{token_list2} should be of same length with \emph{token_list1})}

\item{distinct}{either TRUE or FALSE. If TRUE then the intersection of \emph{distinct} words (or letters) will be taken into account}

\item{letters}{either TRUE or FALSE. If TRUE then the intersection of letters in the text sequences will be computed}
}
\value{
a numeric vector
}
\description{
intersection of words or letters in tokenized text
}
\details{
This class includes methods for text or character intersection. If both \emph{distinct} and \emph{letters} are FALSE then the simple (count or ratio) word intersection will be computed.
}
\section{Methods}{


\describe{
 \item{\code{text_intersect$new(file_data = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{count_intersect(distinct = FALSE, letters = FALSE)}}{}

 \item{\code{--------------}}{}

 \item{\code{ratio_intersect(distinct = FALSE, letters = FALSE)}}{}
 }
}

\examples{

library(textTinyR)

tok1 = list(c('compare', 'this', 'text'),

            c('and', 'this', 'text'))

tok2 = list(c('with', 'another', 'set'),

            c('of', 'text', 'documents'))


init = text_intersect$new(tok1, tok2)


init$count_intersect(distinct = TRUE, letters = FALSE)


init$ratio_intersect(distinct = FALSE, letters = TRUE)
}
\references{
https://www.kaggle.com/c/home-depot-product-search-relevance/discussion/20427 by Igor Buinyi
}
\keyword{datasets}
