% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{select_predictors}
\alias{select_predictors}
\title{Exclude highly correlated predictors}
\usage{
select_predictors(
  response_vector,
  predictors_matrix,
  response_lower_thresh = 0.1,
  predictors_upper_thresh = 0.75,
  threads = 1,
  verbose = FALSE
)
}
\arguments{
\item{response_vector}{a numeric vector (the length should be equal to the rows of the \emph{predictors_matrix} parameter)}

\item{predictors_matrix}{a numeric matrix (the rows should be equal to the length of the \emph{response_vector} parameter)}

\item{response_lower_thresh}{a numeric value. This parameter allows the user to keep all the predictors having a correlation with the response \emph{greater} than the \emph{response_lower_thresh} value.}

\item{predictors_upper_thresh}{a numeric value. This parameter allows the user to keep all the predictors having a correlation comparing to the other predictors \emph{less} than the \emph{predictors_upper_thresh} value.}

\item{threads}{a numeric value specifying the number of cores to run in parallel}

\item{verbose}{either TRUE or FALSE. If TRUE then information will be printed out in the R session.}
}
\value{
a vector of column-indices
}
\description{
Exclude highly correlated predictors
}
\details{
The function works in the following way : The correlation of the predictors with the response is first calculated and the resulted correlations are sorted in decreasing order. Then iteratively predictors with correlation
higher than the \emph{predictors_upper_thresh} value are removed by favoring those predictors which are more correlated with the response variable. If the \emph{response_lower_thresh} value is greater than 0.0 then only predictors
having a correlation higher than or equal to the \emph{response_lower_thresh} value will be kept, otherwise they will be excluded.
This function returns the indices of the \emph{predictors} and is useful in case of multicollinearity.

If during computation the correlation between the response variable and a potential predictor is equal to NA or +/- Inf, then a correlation of 0.0 will be assigned to this particular pair.
}
\examples{

library(textTinyR)

set.seed(1)
resp = runif(100)

set.seed(2)
col = runif(100)

matr = matrix(c(col, col^4, col^6, col^8, col^10), nrow = 100, ncol = 5)

out = select_predictors(resp, matr, predictors_upper_thresh = 0.75)
}
