% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/um.R
\name{um}
\alias{um}
\title{Univariate (ARIMA) model}
\usage{
um(
  z = NULL,
  ar = NULL,
  i = NULL,
  ma = NULL,
  mu = NULL,
  sig2 = 1,
  bc = FALSE,
  fit = TRUE,
  envir = NULL,
  ...
)
}
\arguments{
\item{z}{an object of class \code{ts}.}

\item{ar}{list of stationary AR lag polynomials.}

\item{i}{list of nonstationary AR (I) polynomials.}

\item{ma}{list of MA polynomials.}

\item{mu}{mean of the stationary time series.}

\item{sig2}{variance of the error.}

\item{bc}{logical. If TRUE logs are taken.}

\item{fit}{logical. If TRUE, model is fitted.}

\item{envir}{environment in which the function arguments are evaluated.
If NULL the calling environment of this function will be used.}

\item{...}{additional arguments.}
}
\value{
An object of class \code{um}.
}
\description{
\code{um} creates an S3 object representing a univariate ARIMA model, which
can contain multiple AR, I and MA polynomials, as well as parameter
restrictions.
}
\examples{

ar1 <- um(ar = "(1 - 0.8B)")
ar2 <- um(ar = "(1 - 1.4B + 0.8B^2)")
ma1 <- um(ma = "(1 - 0.8B)")
ma2 <- um(ma = "(1 - 1.4B + 0.8B^2)")
arma11 <- um(ar = "(1 - 1.4B + 0.8B^2)", ma = "(1 - 0.8B)")

}
\references{
Box, G.E.P., Jenkins, G.M., Reinsel, G.C. and Ljung, G.M. (2015) Time Series
Analysis: Forecasting and Control. John Wiley & Sons, Hoboken.
}
