% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf.R
\name{pccf}
\alias{pccf}
\title{Prewhitened cross correlation function}
\usage{
pccf(
  x,
  y,
  um.x = NULL,
  um.y = NULL,
  lag.max = NULL,
  plot = TRUE,
  envir = NULL,
  main = NULL,
  nu.weights = FALSE,
  ...
)
}
\arguments{
\item{x}{input, a 'ts' object or a numeric vector.}

\item{y}{output, a 'ts' object or a numeric vector.}

\item{um.x}{univariate model for input.}

\item{um.y}{univariate model for output.}

\item{lag.max}{number of lags, integer.}

\item{plot}{logical value to indicate if the ccf graph must be graphed or
computed.}

\item{envir}{environment in which the function arguments are evaluated.
If NULL the calling environment of this function will be used.}

\item{main}{title of the graph.}

\item{nu.weights}{logical. If TRUE the coefficients of the IRF are 
computed instead of the cross-correlations.}

\item{...}{additional arguments.}
}
\value{
The estimated cross correlations are displayed in a graph or returned
  into a numeric vector.
}
\description{
\code{pccf} displays cross correlation function between input and output
after prewhitening both through a univariate model.
}
