% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_padded_batch}
\alias{dataset_padded_batch}
\title{Combines consecutive elements of this dataset into padded batches}
\usage{
dataset_padded_batch(
  dataset,
  batch_size,
  padded_shapes,
  padding_values = NULL,
  drop_remainder = FALSE
)
}
\arguments{
\item{dataset}{A dataset}

\item{batch_size}{An integer, representing the number of consecutive elements
of this dataset to combine in a single batch.}

\item{padded_shapes}{A nested structure of tf$TensorShape or integer vector
tensor-like objects representing the shape to which the respective
component of each input element should be padded prior to batching. Any
unknown dimensions (e.g. \code{tf$Dimension(NULL)} in a \code{tf$TensorShape} or -1
in a tensor-like object) will be padded to the maximum size of that
dimension in each batch.}

\item{padding_values}{(Optional) A nested structure of scalar-shaped
tf$Tensor, representing the padding values to use for the respective
components. Defaults are 0 for numeric types and the empty string for
string types.}

\item{drop_remainder}{Ensure that batches have a fixed size by
omitting any final smaller batch if it's present. Note that this is
required for use with the Keras tensor inputs to fit/evaluate/etc.}
}
\value{
A dataset
}
\description{
This method combines multiple consecutive elements of this dataset, which
might have different shapes, into a single element. The tensors in the
resulting element have an additional outer dimension, and are padded to the
respective shape in \code{padded_shapes}.
}
\seealso{
Other dataset methods: 
\code{\link{dataset_batch}()},
\code{\link{dataset_cache}()},
\code{\link{dataset_collect}()},
\code{\link{dataset_concatenate}()},
\code{\link{dataset_decode_delim}()},
\code{\link{dataset_filter}()},
\code{\link{dataset_interleave}()},
\code{\link{dataset_map_and_batch}()},
\code{\link{dataset_map}()},
\code{\link{dataset_prefetch_to_device}()},
\code{\link{dataset_prefetch}()},
\code{\link{dataset_reduce}()},
\code{\link{dataset_repeat}()},
\code{\link{dataset_shuffle_and_repeat}()},
\code{\link{dataset_shuffle}()},
\code{\link{dataset_skip}()},
\code{\link{dataset_take}()},
\code{\link{dataset_window}()}
}
\concept{dataset methods}
