% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/video_dataset.R
\name{video_dataset}
\alias{video_dataset}
\title{Create a \code{VideoDataset} that reads the video file.}
\usage{
video_dataset(filenames)
}
\arguments{
\item{filenames}{A \code{tf.string} tensor containing one or more filenames.}
}
\description{
This allows a user to read data from a video file with ffmpeg. The output of
VideoDataset is a sequence of (height, weight, 3) tensor in rgb24 format.
}
\examples{
\dontrun{
dataset <- video_dataset(
    filenames = list("testdata/small.mp4")) \%>\%
  dataset_repeat(2)

sess <- tf$Session()
iterator <- make_iterator_one_shot(dataset)
next_batch <- iterator_get_next(iterator)

until_out_of_range({
  batch <- sess$run(next_batch)
  print(batch)
})
}

}
