% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts-functions.R
\name{sts_sample_uniform_initial_state}
\alias{sts_sample_uniform_initial_state}
\title{Initialize from a uniform \verb{[-2, 2]} distribution in unconstrained space.}
\usage{
sts_sample_uniform_initial_state(
  parameter,
  return_constrained = TRUE,
  init_sample_shape = list(),
  seed = NULL
)
}
\arguments{
\item{parameter}{\code{sts$Parameter} named tuple instance.}

\item{return_constrained}{if \code{TRUE}, re-applies the constraining bijector
to return initializations in the original domain. Otherwise, returns
initializations in the unconstrained space.
Default value: \code{TRUE}.}

\item{init_sample_shape}{\code{sample_shape} of the sampled initializations.
Default value: \code{list()}.}

\item{seed}{integer to seed the random number generator.}
}
\value{
uniform_initializer \code{Tensor} of shape
\verb{concat([init_sample_shape, parameter.prior.batch_shape, transformed_event_shape])}, where
\code{transformed_event_shape} is \code{parameter.prior.event_shape}, if
\code{return_constrained=TRUE}, and otherwise it is
\code{parameter$bijector$inverse_event_shape(parameter$prior$event_shape)}.
}
\description{
Initialize from a uniform \verb{[-2, 2]} distribution in unconstrained space.
}
\seealso{
Other sts-functions: 
\code{\link{sts_build_factored_surrogate_posterior}()},
\code{\link{sts_build_factored_variational_loss}()},
\code{\link{sts_decompose_by_component}()},
\code{\link{sts_decompose_forecast_by_component}()},
\code{\link{sts_fit_with_hmc}()},
\code{\link{sts_forecast}()},
\code{\link{sts_one_step_predictive}()}
}
\concept{sts-functions}
