% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-kernels.R
\name{mcmc_slice_sampler}
\alias{mcmc_slice_sampler}
\title{Runs one step of the slice sampler using a hit and run approach}
\usage{
mcmc_slice_sampler(
  target_log_prob_fn,
  step_size,
  max_doublings,
  seed = NULL,
  name = NULL
)
}
\arguments{
\item{target_log_prob_fn}{Function which takes an argument like
\code{current_state} (if it's a list \code{current_state} will be unpacked) and returns its
(possibly unnormalized) log-density under the target distribution.}

\item{step_size}{\code{Tensor} or \code{list} of \code{Tensor}s representing the step
size for the leapfrog integrator. Must broadcast with the shape of
\code{current_state}. Larger step sizes lead to faster progress, but
too-large step sizes make rejection exponentially more likely. When
possible, it's often helpful to match per-variable step sizes to the
standard deviations of the target distribution in each variable.}

\item{max_doublings}{Scalar positive int32 \code{tf$Tensor}. The maximum number of
doublings to consider.}

\item{seed}{integer to seed the random number generator.}

\item{name}{string prefixed to Ops created by this function.
Default value: \code{NULL} (i.e., 'slice_sampler_kernel').}
}
\value{
list of
\code{next_state} (Tensor or Python list of \code{Tensor}s representing the state(s)
of the Markov chain(s) at each result step. Has same shape as
and \code{current_state}.) and
\code{kernel_results} (\code{collections$namedtuple} of internal calculations used to
'advance the chain).
}
\description{
Slice Sampling is a Markov Chain Monte Carlo (MCMC) algorithm based, as stated
by Neal (2003), on the observation that "...one can sample from a
distribution by sampling uniformly from the region under the plot of its
density function. A Markov chain that converges to this uniform distribution
can be constructed by alternately uniform sampling in the vertical direction
with uniform sampling from the horizontal \code{slice} defined by the current
vertical position, or more generally, with some update that leaves the uniform
distribution over this slice invariant". Mathematical details and derivations
can be found in Neal (2003). The one dimensional slice sampler is
extended to n-dimensions through use of a hit-and-run approach: choose a
random direction in n-dimensional space and take a step, as determined by the
one-dimensional slice sampling algorithm, along that direction
(Belisle at al. 1993).
}
\details{
The \code{one_step} function can update multiple chains in parallel. It assumes
that all leftmost dimensions of \code{current_state} index independent chain states
(and are therefore updated independently). The output of
\verb{target_log_prob_fn(*current_state)} should sum log-probabilities across all
event dimensions. Slices along the rightmost dimensions may have different
target distributions; for example, \verb{current_state[0, :]} could have a
different target distribution from \verb{current_state[1, :]}. These semantics are
governed by \verb{target_log_prob_fn(*current_state)}. (The number of independent
chains is \verb{tf$size(target_log_prob_fn(*current_state))}.)

Note that the sampler only supports states where all components have a common
dtype.
}
\section{References}{

\itemize{
\item \href{https://projecteuclid.org/download/pdf_1/euclid.aos/1056562461}{Radford M. Neal. Slice Sampling. The Annals of Statistics. 2003, Vol 31, No. 3 , 705-767.}
\item C.J.P. Belisle, H.E. Romeijn, R.L. Smith. \cite{Hit-and-run algorithms for generating multivariate distributions. Math. Oper. Res., 18(1993), 225-266.}
}
}

\seealso{
Other mcmc_kernels: 
\code{\link{mcmc_dual_averaging_step_size_adaptation}()},
\code{\link{mcmc_hamiltonian_monte_carlo}()},
\code{\link{mcmc_metropolis_adjusted_langevin_algorithm}()},
\code{\link{mcmc_metropolis_hastings}()},
\code{\link{mcmc_no_u_turn_sampler}()},
\code{\link{mcmc_random_walk_metropolis}()},
\code{\link{mcmc_replica_exchange_mc}()},
\code{\link{mcmc_simple_step_size_adaptation}()},
\code{\link{mcmc_transformed_transition_kernel}()},
\code{\link{mcmc_uncalibrated_hamiltonian_monte_carlo}()},
\code{\link{mcmc_uncalibrated_langevin}()},
\code{\link{mcmc_uncalibrated_random_walk}()}
}
\concept{mcmc_kernels}
