% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy.R
\name{copy_run}
\alias{copy_run}
\alias{copy_run_files}
\title{Copy run directories}
\usage{
copy_run(run_dir, to = ".", rename = NULL)

copy_run_files(run_dir, to = ".", rename = NULL)
}
\arguments{
\item{run_dir}{Training run directory or data frame returned from
\code{\link[=ls_runs]{ls_runs()}}.}

\item{to}{Name of parent directory to copy run(s) into. Defaults to the
current working directory.}

\item{rename}{Rename run directory after copying. If not specified this
defaults to the basename of the run directory (e.g.
"2017-09-24T10-54-00Z").}
}
\value{
Logical vector indicating which operation succeeded for each of the
run directories specified.
}
\description{
Functions for exporting/copying run directories and run artifact files.
}
\details{
Use \code{copy_run} to copy one or more run directories.

Use \code{copy_run_files} to copy only files saved/generated by training run
scripts (e.g. saved models, checkpoints, etc.).
}
\examples{
\dontrun{

# export a run directory to the current working directory
copy_run("runs/2017-09-24T10-54-00Z")

# export to the current working directory then rename
copy_run("runs/2017-09-24T10-54-00Z", rename = "best-run")

# export artifact files only to the current working directory then rename
copy_run_files("runs/2017-09-24T10-54-00Z", rename = "best-model")

# export 3 best eval_acc to a "best-runs" directory
copy_run(ls_runs(order = eval_acc)[1:3,], to = "best-runs")

}
}
\seealso{
Other run management: 
\code{\link{clean_runs}()}
}
\concept{run management}
