% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Similarities.R
\name{simicount}
\alias{simicount}
\title{Similarity matrix by counting (simicount)}
\usage{
simicount(data)
}
\arguments{
\item{data}{Dataset; one row represents one sorting, objects in one pile 
must have the same number.}
}
\value{
Similarity matrix.
}
\description{
\code{simicount} calculates a similarity matrix for sorting data.
}
\details{
This function is applicable to sorting data. It creates a similarity matrix 
showing how often two objects were in the same pile. Each line of the 
dataset should refer to one sorting. The first column of the input matrix 
should contain the ID of the sorting; the following columns refer to the 
objects that have been sorted. The allocation of objects to piles is  
indicated with numbers; for each line, the objects that were sorted 
into the same pile are given the same number (e.g. all objects with a "1" 
are in one pile, all objects with a "2" are in one pile, etc.). This 
function does not work with missing values.
}
\examples{
## Calculating similarities using sorted data
data(SDG_grouping)
similarities <- simicount(SDG_grouping)
head(similarities)
}
