\name{here}
\alias{here}
\alias{ici}
\title{
Construct Path to File, Beginning with 'this.dir()'
}
\description{
Construct the path to a file from components in a platform-independent way,
starting with \code{\link{this.dir}()}.
}
\usage{
here(..., .. = 0L)
ici(..., .. = 0L)
}
\arguments{
  \item{\dots}{
further arguments passed to \code{\link[base]{file.path}()}.
  }
  \item{..}{
the number of directories to go back.
  }
}
\details{
The path to a file begins with a base. The base is \code{..} number of
directories back from the executing script's directory (\code{this.dir()}). The
argument is named \code{..} because \code{".."} refers to the parent directory
in Windows, Unix, and URL paths alike.
}
\value{
A character vector of the arguments concatenated term-by-term, beginning with
the executing script's directory.
}
% \examples{
% this.path:::write.code(file = FILE <- tempfile(), {
%
%
%     withAutoprint({
%
%
%         this.path::here()
%         this.path::here(.. = 1)
%         this.path::here(.. = 2)
%
%
%         # use 'here' to read input from a file located nearby
%         this.path::here(.. = 1, "input", "file1.csv")
%
%
%         # or maybe to run another script
%         this.path::here("script2.R")
%
%
%     }, verbose = FALSE)
% })
% source(FILE, verbose = FALSE)
% this.path:::.Rscript(c("--default-packages=NULL", "--vanilla", FILE))% essentials::Rscript(c("--default-packages=NULL", "--vanilla"), file = FILE)
% \dontshow{unlink(FILE)}}
\examples{
this.path:::write.code(file = FILE <- tempfile(), {


    this.path::here()
    this.path::here(.. = 1)
    this.path::here(.. = 2)


    # use 'here' to read input from a file located nearby
    this.path::here(.. = 1, "input", "file1.csv")


    # or maybe to run another script
    this.path::here("script2.R")


})


source(FILE, echo = TRUE, verbose = FALSE)
\dontshow{unlink(FILE)}}
