% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThreddsNode.R
\name{ThreddsNode}
\alias{ThreddsNode}
\title{A base representation that other nodes subclass from}
\description{
R6 base class for all other to inherit from
}
\note{
Abstract class. For examples see \link{CatalogNode}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{url}}{character - possibly wrong but usually right!}

\item{\code{node}}{xml2::xml_node}

\item{\code{verbose}}{logical}

\item{\code{prefix}}{xpath namespace prefix, NA or NULL or charcater() to ignore}

\item{\code{tries}}{numeric number of requests attempts before failing}

\item{\code{encoding}}{character, by default 'UTF-8'}

\item{\code{base_url}}{character, the base URL for the service}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ThreddsNode$new()}}
\item \href{#method-print}{\code{ThreddsNode$print()}}
\item \href{#method-GET}{\code{ThreddsNode$GET()}}
\item \href{#method-browse}{\code{ThreddsNode$browse()}}
\item \href{#method-children_names}{\code{ThreddsNode$children_names()}}
\item \href{#method-clone}{\code{ThreddsNode$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
initialize an instance of ThreddsNode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ThreddsNode$new(
  x,
  verbose = FALSE,
  n_tries = 3,
  prefix = NULL,
  ns_strip = FALSE,
  encoding = "UTF-8",
  base_url = ""
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{url or xml2::xml_node}

\item{\code{verbose}}{logical, TRUE to be noisy (default FALSE)}

\item{\code{n_tries}}{numeric, defaults to 3}

\item{\code{prefix}}{character, the namespace to examine (default NULL, inherited when initialized)}

\item{\code{ns_strip}}{logical, if TRUE then strip namespace (default FALSE)}

\item{\code{encoding}}{character, by default 'UTF-8'}

\item{\code{base_url}}{character, the base URL for the service}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ThreddsNode$print(prefix = "", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{character, to be printed before each line of output (like spaces)}

\item{\code{...}}{other argum,ents (ignored for now)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GET"></a>}}
\if{latex}{\out{\hypertarget{method-GET}{}}}
\subsection{Method \code{GET()}}{
Retrieve a node of the contents at this nodes URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ThreddsNode$GET()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
ThreddsNode or subclass or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-browse"></a>}}
\if{latex}{\out{\hypertarget{method-browse}{}}}
\subsection{Method \code{browse()}}{
Browse the URL if possible
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ThreddsNode$browse()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-children_names"></a>}}
\if{latex}{\out{\hypertarget{method-children_names}{}}}
\subsection{Method \code{children_names()}}{
Retrieve a vector of unique child names
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ThreddsNode$children_names(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{further arguments for \code{\link{xml_children_names}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a vector of zero or more child names
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ThreddsNode$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
