% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplus.R
\name{make_mplus_code}
\alias{make_mplus_code}
\title{Generate Mplus code for Thurstonian IRT models}
\usage{
make_mplus_code(data, iter = 1000, eta_file = "eta.csv")
}
\arguments{
\item{data}{An object of class \code{'TIRTdata'}. see
\code{\link{make_TIRT_data}} for documentation on how to create one.}

\item{iter}{Maximum number of iterations of the
model fitting algorithm.}

\item{eta_file}{optional file name in which predicted
trait scores should be stored.}
}
\value{
A list of Mplus code snippets to be
interpreted by the \pkg{MplusAutomation} package.
}
\description{
Generate Mplus code for Thurstonian IRT models
}
\examples{
sim_data <- sim_TIRT_data(
  npersons = 100,
  ntraits = 3,
  nblocks_per_trait = 4,
  gamma = 0,
  lambda = c(runif(6, 0.5, 1), runif(6, -1, -0.5)),
  Phi = diag(3)
)

# show the created Mplus code
lapply(make_mplus_code(sim_data), cat)

}
