% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_profiles_mplus.R
\name{estimate_profiles_mplus}
\alias{estimate_profiles_mplus}
\title{Create models for a specific mclust model}
\usage{
estimate_profiles_mplus(df, ..., n_profiles, the_title = "test",
  data_filename = "d.dat", script_filename = "i.inp",
  output_filename = "i.out", savedata_filename = "d-mod.dat", model = 1,
  starts = c(20, 4), m_iterations = 500, st_iterations = 10,
  convergence_criterion = 1e-06, remove_tmp_files = TRUE,
  print_input_file = FALSE, return_save_data = TRUE, optseed = NULL,
  n_processors = 1)
}
\arguments{
\item{df}{data.frame with two or more columns with continuous variables}

\item{...}{unquoted variable names separated by commas}

\item{n_profiles}{the number of profiles (or mixture components) to be estimated}

\item{the_title}{title of the model; defaults to test}

\item{data_filename}{name of data file to prepare; defaults to d.dat}

\item{script_filename}{name of script to prepare; defaults to i.inp}

\item{output_filename}{name of the output; defaults to o.out}

\item{savedata_filename}{name of the output for the save data (with the original data conditional probabilities); defaults to o-mod.out}

\item{model}{the mclust model to explore: 1 (varying means, equal variances, and residual covariances fixed to 0); 2 (varying means, equal variances and covariances; 3 (varying means and variances, covariances fixed to 0), 4 (varying means and covariances, equal variances; can only be specified in Mplus); 5 (varying means, equal variances, varying covariances); and 6 (varying means, variances, and covariances), in order least to most freely-estimated; see the introductory vignette for more information}

\item{starts}{number of initial stage starts and number of final stage optimizations; defaults to c(20, 4); can be set to be more conservative to c(500, 50)}

\item{m_iterations}{number of iterations for the EM algorithm; defaults to 500}

\item{st_iterations}{the number of initial stage iterations; defaults to 10; can be set more to be more conservative to 50}

\item{convergence_criterion}{convergence criterion for the Quasi-Newton algorithm for continuous outcomes; defaults to 1E-6 (.000001); can be set more conservatively to 1E-7 (.0000001)}

\item{remove_tmp_files}{whether to remove data, script, and output files; defaults to TRUE}

\item{print_input_file}{whether to print the input file to the console}

\item{return_save_data}{whether to return the save data (with the original data and the posterior probabilities for the classes and the class assignment) as a data.frame along with the MPlus output; defaults to TRUE}

\item{optseed}{random seed for analysis}

\item{n_processors}{= 1}
}
\value{
either a tibble or a ggplot2 plot of the BIC values for the explored models
}
\description{
Create models for a specific mclust model
}
\details{
Creates an mplus model (.inp) and associated data file (.dat)
}
\examples{
\dontrun{
m1 <- estimate_profiles_mplus(iris,
                            Sepal.Length, Sepal.Width, Petal.Length, Petal.Width,
                            n_profiles = 2,
                            model = 1)
}
}
