% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_profiles_mplus.R
\name{estimate_profiles_mplus}
\alias{estimate_profiles_mplus}
\title{Estimate parameters for profiles for a specific solution (requires purchasing and installing MPlus to use)}
\usage{
estimate_profiles_mplus(df, ..., n_profiles, idvar = NULL,
  data_filename = "d.dat", script_filename = "i.inp",
  output_filename = "i.out", savedata_filename = "d-mod.dat",
  variances = "equal", covariances = "zero", model = NULL,
  starts = c(100, 10), m_iterations = 500, st_iterations = 20,
  convergence_criterion = 1e-06, remove_tmp_files = TRUE,
  print_input_file = FALSE, return_save_data = TRUE, optseed = NULL,
  n_processors = 1, cluster_ID = NULL, include_VLMR = TRUE,
  include_BLRT = FALSE, return_all_stats = FALSE)
}
\arguments{
\item{df}{data.frame with two or more columns with continuous variables}

\item{...}{unquoted variable names separated by commas}

\item{n_profiles}{the number of profiles (or mixture components) to be estimated}

\item{idvar}{optional name of the column to be used as the ID variable (should be supplied as a string). Defaults to \code{NULL}, in which case row numbers will be used. Note the ID can be numeric or string, but must be unique.}

\item{data_filename}{name of data file to prepare; defaults to d.dat}

\item{script_filename}{name of script to prepare; defaults to i.inp}

\item{output_filename}{name of the output; defaults to o.out}

\item{savedata_filename}{name of the output for the save data (with the original data conditional probabilities); defaults to o-mod.out}

\item{variances}{how the variable variances are estimated; defaults to "equal" (to be constant across profiles); other option is "varying" (to be varying across profiles)}

\item{covariances}{how the variable covariances are estimated; defaults to "zero" (to not be estimated, i.e. for the covariance matrix to be diagonal); other options are "varying" (to be varying across profiles) and "equal" (to be constant across profiles)}

\item{model}{which model to estimate (DEPRECATED; use variances and covariances instead)}

\item{starts}{number of initial stage starts and number of final stage optimizations; defaults to c(20, 4); can be set to be more conservative to c(500, 50)}

\item{m_iterations}{number of iterations for the EM algorithm; defaults to 500}

\item{st_iterations}{the number of initial stage iterations; defaults to 10; can be set more to be more conservative to 50}

\item{convergence_criterion}{convergence criterion for the Quasi-Newton algorithm for continuous outcomes; defaults to 1E-6 (.000001); can be set more conservatively to 1E-7 (.0000001)}

\item{remove_tmp_files}{whether to remove data, script, and output files; defaults to TRUE}

\item{print_input_file}{whether to print the input file to the console}

\item{return_save_data}{whether to return the save data (with the original data and the posterior probabilities for the classes and the class assignment) as a data.frame along with the MPlus output; defaults to TRUE}

\item{optseed}{random seed for analysis}

\item{n_processors}{= 1}

\item{cluster_ID}{clustering variable (i.e., if data are from students clustered into distinct classrooms) to be used as cluster variables as part of the type = complex option}

\item{include_VLMR}{whether to include the Vu-Lo-Mendell-Rubin likelihood-ratio test; defaults to TRUE}

\item{include_BLRT}{whether to include the bootstrapped LRT; defaults to FALSE because of the time this takes to run}

\item{return_all_stats}{defaults to FALSE; if TRUE, returns as a one-row data frame all of the statistics returned from compare_solutions_mplus()}
}
\value{
either a tibble or a ggplot2 plot of the BIC values for the explored models
}
\description{
Estimate parameters for profiles for a specific solution (requires purchasing and installing MPlus to use)
}
\details{
Creates an mplus model (.inp) and associated data file (.dat)
}
\examples{
\dontrun{
m <- estimate_profiles_mplus(iris,
                            Sepal.Length, Sepal.Width, Petal.Length, Petal.Width,
                            n_profiles = 2)
}
}
