% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-plot_sem.R
\name{prepare_graph}
\alias{prepare_graph}
\alias{prepare_graph.default}
\alias{prepare_graph.lavaan}
\alias{prepare_graph.mplus.model}
\title{Prepare graph data}
\usage{
prepare_graph(...)

\method{prepare_graph}{default}(
  edges = NULL,
  layout = NULL,
  nodes = NULL,
  rect_width = 1.2,
  rect_height = 0.8,
  ellipses_width = 1,
  ellipses_height = 1,
  variance_diameter = 0.8,
  spacing_x = 2,
  spacing_y = 2,
  text_size = 4,
  curvature = 60,
  angle = NULL,
  fix_coord = FALSE,
  ...
)

\method{prepare_graph}{lavaan}(model, ...)

\method{prepare_graph}{mplus.model}(model, ...)
}
\arguments{
\item{...}{Additional arguments passed to and from functions.}

\item{edges}{Object of class 'tidy_edges', or a \code{data.frame} with  (at
least) the columns \code{c("from", "to")}, and optionally, \code{c("arrow",
"label", "connect_from", "connect_to", "curvature")}.}

\item{layout}{A matrix (or data.frame) that describes the layout; see
\code{\link[tidySEM]{get_layout}}.}

\item{nodes}{Optional, object of class 'tidy_nodes', created with the
\code{\link[tidySEM]{get_nodes}} function, or a \code{data.frame} with (at
least) the column \code{c("name")}, and optionally, \code{c("shape",
"label")}. If set to \code{NULL} (the default), nodes are inferred from the
\code{layout} and \code{edges} arguments.}

\item{rect_width}{Width of rectangles (used to display observed variables),
Default: 1.2}

\item{rect_height}{Height of rectangles (used to display observed variables),
Default: 0.8}

\item{ellipses_width}{Width of ellipses (used to display latent variables),
Default: 1}

\item{ellipses_height}{Height of ellipses (used to display latent variables),
Default: 1}

\item{variance_diameter}{Diameter of variance circles,
Default: .8}

\item{spacing_x}{Spacing between columns of the graph, Default: 1}

\item{spacing_y}{Spacing between rows of the graph, Default: 1}

\item{text_size}{Point size of text, Default: 4}

\item{curvature}{Curvature of curved edges. The curve is a circle segment
originating in a point that forms a triangle with the two connected points,
with angles at the two connected points equal to \code{curvature}.
To flip a curved edge, use a negative value for curvature. Default: 60}

\item{angle}{Angle used to connect nodes by the top and bottom. Defaults to
NULL, which means Euclidean distance is used to determine the shortest
distance between node sides. A numeric value between 0-180 can be provided,
where 0 means that only nodes with the same x-coordinates are connected
top-to-bottom, and 180 means that all nodes are connected top-to-bottom.}

\item{fix_coord}{Whether or not to fix the aspect ratio of the graph.
Does not work with multi-group or multilevel models.
Default: FALSE.}

\item{model}{Instead of the edges argument, it is also possible to use the
model argument and pass an object for which a method exists (e.g.,
\code{mplus.model} or \code{lavaan}).}
}
\value{
Object of class 'sem_graph'
}
\description{
Prepare an object of class \code{sem_graph}, containing
data objects that can be rendered into a SEM graph. Using this function
allows
users to manually change the default graph specification before plotting it.
Input consists of (at least) a layout, and either nodes and edges, or
a model object.
}
\examples{
library(lavaan)
res <- sem("dist ~ speed", cars)
prepare_graph(res)
}
