% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openmx_functions.R
\name{as_ram}
\alias{as_ram}
\title{Convert lavaan syntax to RAM specification}
\usage{
as_ram(x, ...)
}
\arguments{
\item{x}{An object for which a method exists, such as a \code{tidy_sem}
object, or character vector describing the user-specified model using
the lavaan model syntax.}

\item{...}{Parameters passed on to other functions.}
}
\value{
Returns an \code{\link[OpenMx]{mxModel}}.
}
\description{
Converts SEM models to RAM models for
\code{OpenMx}.
}
\details{
For models specified using lavaan syntax, the procedure is as
follows:
\enumerate{
 \item Apply \code{\link[lavaan]{lavaanify}} to the \code{model}. The default
 arguments to \code{\link[lavaan]{lavaanify}} correspond to those of the
 \code{\link[lavaan]{sem}} function.
 \item Convert each row of the resulting lavaan parameter table to a
 \code{\link[OpenMx]{mxPath}}.
 \item Apply \code{\link[OpenMx]{mxModel}} to the \code{mxPath}s to create
 an \code{OpenMx} model using RAM specification
}
}
\examples{
as_ram("y ~ x")
}
