# Building model with umxThresholdMatrix works:
df <- eval(parse(text = 'structure(list(V1 = c(-0.723313, 2.231216, -1.291729, 0.011013,
-0.045636, -4.053967, -0.734269, 1.619908, -0.251358, 1.977465,
0.008706, 1.449868, -0.425644, -1.375329, -0.741892, -0.146341,
-1.789703, -1.091391, -2.137643, -1.825095, -1.722729, 1.587158,
0.792942, -1.040632, -1.378654, 0.085925, -0.94496, -0.541314,
3.352086, 0.820784, -1.056632, -1.674908, -1.751532, -0.420768,
-0.714594, -1.447618, -0.093092, -2.490734, -0.756829, 0.67723,
0.599984, 2.782081, 2.780595, -0.041991, 2.057776, 1.137475,
2.747873, -0.032044, -2.843805, -0.290844, -0.479094, -1.260303,
-1.869987, -1.458339, 1.049839, 1.818125, 0.248098, -0.25997,
-0.648072, -0.47294, 0.757786, -0.724991, 1.667981, 0.551045,
0.213538, -1.469487, -1.963471, -2.102895, 2.351265, 0.293285,
-0.586964, 1.461683, 2.141563, 1.162113, 0.305257, 1.27256, -1.485495,
0.134244, -0.382005, -2.078822, 0.962425, -0.418305, 0.1564,
-0.583823, -1.256565, -2.3597, 0.06225, -0.474712, 2.359876,
1.247573, -3.126569, -0.596212, -0.293985, 2.40102, -0.253824,
-0.565604, 0.043344, 1.718179, -1.210093, 2.323112, 0.565926,
-0.228784, -1.413013, 0.608145, 2.322426, -0.71909, 1.189126,
-1.416823, -1.098261, -1.443777, 0.4706, -0.494431, 1.638587,
-0.344784, -1.336395, -1.043447, -0.49273, -1.974997, -1.640298,
1.180597, -1.265186, 0.284013, 0.886985, 0.618804, 0.582567,
-2.098375, -1.522923, -2.905923, 0.095633, 0.847987, -0.115703,
0.095415, 0.210884, 0.83533, -0.433484, -0.263124, 1.665165,
1.960349, 0.869608, -1.790441, 0.821313, 1.211644, -1.989626,
1.678806, -3.090276, 1.31054, -1.403629, -1.037174, 0.168655,
0.147336, 1.569733, 1.513182, 0.549185, -2.576222, 3.306831,
-2.375876, 1.589114, 0.861471, 0.502603, 1.042703, 2.069624,
-1.300558, 1.668843, 0.632288, -0.42959, -3.125203, -0.492225,
2.720526, 3.914089, -0.163782, 0.764157, 1.435863, -1.580416,
1.32585, -0.211541, 0.625891, -1.149942, 0.430844, 1.256022,
-2.456321, -0.261909, -0.940597, 1.640881, -1.511875, 1.655906,
0.718111, -1.339151, -1.011365, 1.725315, 0.982591, -1.423779,
0.848289, -0.119767, -0.489705, -2.760427, -0.720068, 0.50741,
-0.883997, -3.347907, -0.455188, 1.443215, 0.283688, -0.155738,
-1.624686, 1.391934, 1.398308, -1.065899, -0.974203, 1.305549,
2.093853, -1.71448, -2.445271, 0.833881, 0.40429, -1.046637,
-1.428714, 1.449649, 0.716681, 1.632659, -1.186968, -1.65874,
-0.581003, 0.914749, -1.917339, 0.923527, 0.843163, -2.254566,
2.602076, 0.662488, 1.592779, 0.015215, 0.455287, -2.846406,
1.897988, 0.598233, 1.479182, 2.027362, 0.703204, 0.137045, -2.756372,
-2.370065, 1.656496, -0.08291, -2.948552, 0.538758, 1.016007,
2.482211, 1.965861, -0.204021, -0.740104, 2.086916, -0.926821,
-1.462023, 1.354947, 3.116579, 1.654555, -2.570013, 1.007584,
-2.310355, -1.019345, -0.832799, 2.655117, -0.766914, 0.574137,
-0.769901, 0.966443, -0.792829, 0.815349, -0.330349, -0.107316,
-1.227271, -0.32297, -0.575113, -0.6787, 2.643631, 0.114776,
-1.841385, 2.366877, -1.503915, -1.140921, -1.683783, -1.281676,
0.097012, 1.14494, 1.883911, 0.380544, -0.104954, -0.887768,
-0.535712, 0.959198, 1.989752, -1.479636, 0.995044, -0.384206,
1.663277, 2.757946, 1.083746, 1.137018, 1.931825, -1.235653,
-1.220737, -1.315043, 0.269057, -1.148184, -0.044597, -0.02572,
-1.923819, -1.729315, 0.889406, -1.185957, -1.927763, -2.221358,
-0.672993, -0.550727, 1.4758, 0.214918, 0.907257, 0.167367, 3.126832,
0.15673, -0.73976, -1.127432, -0.510273, 1.591508, 3.812323,
-0.270237, -3.613922, -0.39494, 1.403141, 0.973658, 0.943281,
1.833985, -1.243736, 3.141743, -0.41545, 0.624431, 0.08595, -0.546934,
0.215748, 0.617057, -2.050041, -1.399085, 1.978455, 1.168734,
-0.648363, 0.394491, -0.986462, 0.506983, 1.458513, 3.231622,
-1.619744, 0.131387, 0.690921, -0.520662, 0.68524, 0.139978,
-0.945253, 0.136951, 2.265795, -0.646178, 0.965917, -3.194136,
1.935702, 1.993917, 3.692052, -1.096532, -0.066634, -0.621529,
-0.247296, -1.600745, -2.286984, -0.137291, -0.336027, -0.159867,
1.617143, -2.390961, 0.372016, -2.333679, 2.407459, 1.524528,
-0.594601, -0.997021, 1.281674, -0.426913, 0.772961, 3.182425,
2.275893, -0.32117, -0.821925, -2.549203, -0.680104, 1.461502,
-1.639207, -1.934205, -3.207516, -0.015658, -1.0748, 2.110855,
2.1488, -1.909729, 1.187745, -1.199131, -2.392922, 0.534857,
1.43504, 2.039783, 1.94045, 1.644131, -2.153912, -1.33465, -0.125048,
-1.752257, 2.092699, 0.049088, 1.235393, -0.728256, 0.096464,
-0.024324, -1.372714, -2.268502, -1.214282, 0.279554, 3.727352,
1.247994, 1.442593, 2.992634, 2.457367, -0.329409, 0.445866,
0.501811, -0.046374, -0.94528, -0.34587, 1.082732, 0.372669,
1.113425, 1.92511, -2.92565, 0.247729, 0.314498, -0.195986, -0.438829,
1.230618, -0.373832, 0.078784, 0.992865, 1.74557, 0.113247, 0.207565,
-0.145798, -1.855763, -1.353336, -2.674013, 1.854247, -0.765841,
0.908848, -1.490184, -1.758543, -0.81547, -0.944238, -1.104576,
1.68304, 1.376678, -0.82077, 1.681481, -1.849309, -0.321736,
2.417015, 0.9779, 0.948022, -1.543329, 1.287987, 2.917988, -1.366112,
0.49545, -1.942959, -1.099173, 0.781931, 0.673841, 0.668805,
-2.471131, 2.284118, 1.563399, -0.065555, 1.805828, -1.877671,
0.531237, 0.734912, -1.237141, -1.317446, -1.44747, 1.42749,
-2.25093, 1.531139, 0.42047, 1.012009, 1.522308, 1.230604, 1.525109,
1.793174), V2 = c(-1.590426, -0.310479, 0.614144, -1.608493,
0.767699, -2.266275, -0.745245, 2.116445, -2.690158, 1.966632,
0.112178, 0.490622, 0.408139, -1.110748, -3.629101, -1.958029,
-0.33299, -2.414205, 0.020125, -1.983972, -0.241704, 1.225887,
2.480743, -0.684101, 1.582679, 2.668053, -1.891695, -0.897598,
0.817582, 2.279146, -0.706051, -1.633715, -1.366171, 0.243185,
-1.131635, -1.537589, -1.67363, -0.11345, -2.582667, 1.113892,
-1.199806, 0.052326, -1.087324, 1.738265, 0.769355, -1.292292,
1.101479, 2.160563, -0.602751, -2.488704, -0.344244, -1.286522,
0.135281, -0.711602, 1.906541, 1.070876, -1.228186, -0.917226,
-0.342876, -0.333689, -0.155017, -1.820419, -0.286388, 1.445694,
1.707951, -0.893692, 0.776869, -1.065578, 0.903166, 2.175201,
0.377961, -1.063881, 3.360709, 1.816379, 0.080854, -0.150515,
-1.241135, 1.004305, -1.778044, -1.147124, -1.534605, 1.359701,
0.526662, -0.834868, 2.571285, -3.486019, 0.645422, -0.905404,
0.147975, 1.686597, -0.928991, 0.481236, 2.24246, 0.902773, 0.000823,
-0.07131, 0.197058, 2.622223, 1.516181, 1.625414, 1.711342, 0.112705,
-1.593082, 0.222625, 0.831517, 1.852273, -0.056981, -1.136759,
-1.721422, 0.095365, 0.084327, 0.746175, 0.252754, -0.068813,
-1.025226, -1.422978, 0.451222, -1.542178, -2.361671, -0.742213,
-0.937082, 0.453146, 2.613971, -1.94296, 1.301495, -1.316497,
-0.044412, -2.150734, 2.64299, 2.746479, 0.353841, -1.54076,
2.2026, -0.575291, -1.60705, -0.641877, 0.374137, 1.769547, 1.820764,
-1.96437, 1.157083, -2.381562, -0.699874, 1.738635, -0.26894,
1.669274, 0.17274, -1.978568, 0.675488, 0.081386, 1.383735, -0.008662,
0.036052, -1.627013, 0.805844, -1.878472, 0.43623, -0.179793,
0.037287, 1.121378, 0.490525, -2.357557, -0.372949, 1.414842,
-1.767803, -0.528961, -0.387021, 1.9704, 3.23378, 1.556857, 1.328423,
0.579521, -1.005945, 0.354521, -0.730054, -1.694185, -0.730657,
0.709635, -0.723524, -0.920469, -0.742971, 0.1293, 2.413036,
-1.042595, -0.015071, 0.337514, -2.147534, -1.243467, 1.705854,
-2.301246, -0.833921, 2.307967, -2.147108, -0.89284, -0.857837,
-1.314204, -1.665349, 2.217506, -1.038647, -2.784374, 0.637468,
1.185945, -1.626547, -0.285956, 0.792355, 1.090109, -0.120715,
-1.051571, 0.10157, -0.147314, -1.749116, -1.246123, -0.801803,
1.852173, -1.074153, -1.912714, 0.925782, 0.402958, -0.445116,
-1.525513, -2.164318, -0.646264, 0.235965, -1.765843, 1.178908,
0.220035, -1.885195, 0.26613, 0.015467, 2.40193, 2.677139, 2.184404,
-1.265921, 0.1688, -0.10975, 2.458039, 0.799079, -0.227514, -2.598135,
-2.106563, -0.546964, 0.765051, -0.548946, -2.660965, 0.693888,
1.856131, 1.400917, 1.774757, 0.717251, -0.071992, 0.498564,
0.262776, -1.25216, 1.38376, -1.221296, -0.669768, -1.168128,
2.133068, -0.038508, -2.060365, -0.703786, 0.991174, 0.574672,
0.760199, -1.439384, 0.131014, -0.530545, 0.56592, 0.347445,
2.257339, -0.82741, -1.163316, 0.766442, 0.855229, 2.068956,
-3.501257, 0.612959, 1.874435, -0.456001, 1.388888, 0.815495,
-0.559956, 0.184063, -2.266624, 0.188673, -0.148064, 2.126578,
-0.354083, 2.457208, -1.698528, 1.390163, -0.90557, 1.277204,
-3.272524, -0.031529, 1.540866, 0.937831, 0.533864, -0.926217,
-2.116477, -2.489875, -1.253625, -1.030947, -0.031137, -0.860853,
-2.288332, -0.227269, -0.650037, -1.390701, -0.145058, -1.578068,
-0.789691, -1.278363, -0.734565, -0.155364, 0.411383, -0.394051,
0.894396, 0.245559, -0.520301, -1.903536, -0.661493, 0.250267,
0.579995, 1.848934, -1.543657, -2.23181, -0.325854, 0.845486,
1.145731, 0.660148, 1.379319, -2.587704, 2.321569, -3.132457,
1.186487, 0.507905, 0.917824, -1.703669, -1.009468, -2.571047,
-0.275987, 0.984596, 2.305681, -0.733303, 1.652715, -1.132571,
0.21122, 0.62295, 1.110665, -1.267643, -2.311188, 2.273943, -1.473485,
0.390984, 0.088686, -2.181451, 0.287213, 1.469295, -2.688365,
1.929727, -2.259062, 2.389006, -0.500084, 0.714798, -1.093717,
0.55936, -1.245179, 2.793905, 0.652816, -1.923501, -0.466689,
-0.091679, 1.438464, 2.487401, -1.737393, 0.279702, -0.826489,
0.97455, 0.496434, 0.878788, 2.405081, 0.625491, 2.691429, 0.864621,
0.866287, 2.457739, -0.736485, 1.947439, -0.781067, 1.824753,
-0.120816, -0.496611, -2.211366, -2.133199, -0.29428, -2.633425,
1.656381, 1.684733, -0.035057, 2.849577, -2.395081, -1.174943,
0.440354, 2.675574, 2.217125, 1.529094, 1.44004, -0.207018, 0.375606,
2.950006, -1.895553, -0.107887, 0.831028, 1.445593, -2.79576,
1.33737, 0.479696, -2.403336, 1.086964, -2.180161, -0.990848,
0.214462, -0.194067, 0.572061, 2.036202, 1.469526, 3.137979,
1.419474, 2.336135, 0.729241, 0.590617, -1.672355, 0.494291,
0.414112, 0.755348, 1.646032, 0.392056, 0.210987, 0.641774, 0.091517,
-0.118995, -0.83595, 0.269336, -2.268656, 0.384111, 0.415725,
0.875926, 0.738015, 0.120115, 0.22042, -1.680516, -0.600169,
1.304637, -0.864102, 0.824928, -0.736258, -1.640344, -1.423866,
-1.927861, -1.58656, 1.661997, 1.173073, -1.510817, 1.237302,
-0.832295, 0.676644, 0.02523, 1.11378, 3.259044, 3.514631, 2.49705,
2.023243, -0.639137, -0.666514, -0.015447, -0.290687, 0.034706,
-0.509058, -1.133858, -1.660528, 0.82547, 0.445246, 0.808643,
1.253653, -0.044601, 2.446418, 0.395929, -0.239728, -1.240886,
-2.846385, 0.339682, -1.392825, 2.032685, 0.477141, -0.654418,
1.516, -1.455927, 1.632113, -0.008483), V3 = c(-1.997867, -1.175523,
-0.74046, 0.679076, -2.29254, -0.677409, -0.608782, 0.930357,
-0.497587, 0.481998, 0.964739, 1.662234, -0.800131, -0.254952,
-2.205869, -1.37865, -1.813875, -0.710983, -1.259088, 0.87375,
-0.550165, -0.291667, 0.392279, -0.339761, 2.069903, 0.006058,
-1.826061, -1.441021, 1.026084, 0.762607, -0.884842, -1.278641,
-1.601087, 1.148414, -0.360068, -0.299987, -2.490399, -2.013107,
-1.49578, 1.047285, -0.371515, 0.092638, 1.752114, 2.527916,
0.467157, 0.248168, 1.118131, 2.208892, -0.345818, -0.606432,
0.750921, -0.824989, -1.673589, 0.174944, -0.037979, -0.58876,
-0.085488, 2.432771, 0.252526, -1.609767, 0.09442, -0.471907,
1.211154, 1.600636, 0.025832, -0.387381, -2.150767, -1.821394,
0.44401, 1.435246, -1.008939, 0.157702, 1.604481, -0.638472,
1.220094, 0.458588, -2.85107, 0.059497, -1.107319, -0.741936,
-1.546211, 0.079882, 2.412717, -0.590548, -1.310978, 0.178959,
0.653422, -0.11541, 0.994212, 0.91802, -2.257376, 0.346729, 1.256868,
1.226672, -1.12629, -0.416061, -1.481797, 2.385603, -0.971768,
1.505803, 1.509436, -0.074323, 0.620118, -1.305822, 0.254234,
1.694533, 2.555776, -2.559208, -0.965793, -0.121753, 2.382481,
0.959087, 0.656049, -0.309676, 0.028223, 0.496189, -1.750455,
-0.826176, -0.696271, 1.426082, -1.816528, 1.063282, 1.91183,
-1.422945, -0.643003, -0.373053, -2.482862, -0.289907, 1.646944,
1.199106, 0.144012, -0.821709, 0.249514, -0.10852, -1.455537,
-1.941663, 3.303087, 2.846719, 0.297787, -1.650273, 1.280551,
-2.03568, -0.744201, 0.074033, -0.549826, 1.904582, 0.01644,
-1.72063, 0.382522, -0.778516, -0.763382, -0.803711, 1.310534,
-1.156339, -0.467458, -1.792056, 0.433687, 1.301007, 0.708433,
0.395727, 1.635655, -0.861968, -0.786274, 0.033748, -1.95112,
-0.837634, -1.796677, 2.332765, -0.199198, 1.573795, -0.774832,
0.006016, -0.167312, -0.116103, 0.240662, -1.775292, -2.09157,
2.975173, 0.789329, -1.456092, -1.014755, -2.296978, 0.527724,
0.130389, 0.278299, 1.107055, -0.664054, 0.746785, -0.801035,
-0.750756, -1.783658, 0.975455, -1.656817, -2.52649, -0.898303,
-1.379753, -2.256628, -0.265443, 1.110454, -0.160234, 1.837258,
0.040942, 0.219177, -0.510405, 2.403778, 0.696504, 0.407621,
-1.294317, 1.810933, 0.559826, -0.652136, -0.715319, -1.615352,
1.30352, -1.74667, -0.120803, 2.639264, 2.19083, -0.97788, -1.099845,
0.050657, -1.638372, 0.674253, -0.581534, 0.22829, -0.055764,
-0.069742, 0.781446, -0.929274, 0.919144, 1.897033, 0.895844,
0.697233, -1.075039, -1.581438, 1.323881, 1.265955, 2.756907,
-0.386344, -0.340987, -0.024039, 1.256458, -0.479744, -0.485129,
1.42061, -0.341043, 1.23775, -1.444456, 0.882872, -1.187189,
1.182748, -0.624724, 0.171539, 0.996129, 2.503489, 1.082272,
1.028109, -0.279316, -1.142887, -1.695896, -2.159183, 3.056783,
-0.193575, 1.438197, -1.406109, 0.899752, 0.112958, -0.13885,
-0.457805, 1.927996, -0.278455, 0.502036, -1.32826, 1.633469,
0.461173, 0.041814, -0.692902, -0.604513, 0.892568, -0.967535,
-0.935895, -2.601051, -0.60593, -2.103826, 1.717496, -1.517536,
-1.069555, -0.660001, 1.638221, -0.290755, 2.376586, -0.97243,
0.3537, -0.813185, 0.269569, 2.495184, 1.274937, 0.094173, 1.645133,
-1.366056, -1.132994, -1.557032, -0.422672, -2.196123, -2.750496,
-1.941472, -1.595109, -0.961605, -0.704793, -1.57642, -0.132593,
-0.977442, -1.580419, 0.222255, 0.386723, -0.612455, -1.790576,
2.686754, 0.409469, -0.991343, -0.431005, -1.543963, -0.957386,
1.083156, 1.724439, 0.284032, -4.511233, -0.068664, 1.993984,
0.581135, 1.071373, 1.041411, -0.923205, 0.367403, -2.406321,
-0.080743, -1.979099, 0.529181, -0.71965, -1.466245, -0.445076,
-0.782632, 1.280306, 2.672126, -1.337477, -0.534892, 0.294481,
0.85914, 2.074086, -0.131555, -0.352966, -0.838742, -0.536932,
-1.109871, 3.007927, 0.34345, 0.166892, -0.497786, -0.05808,
-0.459192, 1.031292, -1.273253, 0.632171, 0.644215, 0.649075,
0.659695, 2.082772, 0.952894, 1.607214, -1.808026, -1.313654,
-1.245992, 0.162127, 0.997919, 0.102995, 0.230856, -0.341128,
-1.849877, -0.681661, 0.661082, 1.968001, -0.132568, 1.477771,
0.136246, 1.053171, 1.250221, 2.47133, -0.514943, 0.954504, -1.298659,
2.280576, -2.430255, 0.994044, -1.290135, -2.919029, 2.34931,
-1.840741, 0.99512, -0.049216, -3.090427, 0.786052, 0.650105,
-0.680113, 1.212427, -0.139237, 0.14729, 1.655169, 1.741199,
-1.766803, 0.215159, 1.204017, 0.589492, 0.510273, 1.391389,
1.404371, -0.180464, 2.094603, -0.326283, -1.56746, -2.101897,
0.243743, -1.448558, 1.377101, 2.287847, 0.803475, 1.147657,
2.414447, -0.090513, 0.471595, 1.195643, 1.202157, -0.801936,
-0.781081, 2.595921, -0.007736, -0.195792, 0.291813, -1.361875,
1.60432, 2.039621, 0.687242, -0.421541, -1.097518, 0.748952,
-0.039097, 2.227126, 0.701662, 0.210952, 1.360127, 1.551, 0.725669,
-1.164048, -1.053467, 2.304004, -1.793986, 1.653218, 0.902313,
-0.523018, -1.092384, -2.245499, -1.421302, 1.035356, 0.938969,
-1.267604, 2.26937, -2.067152, 2.602984, 2.320145, 0.597328,
-0.706136, 0.18009, 3.809585, 3.546188, -0.550499, 1.579908,
-1.353499, -2.102813, 0.093989, -0.436731, -0.818416, -2.12182,
2.212616, -0.085384, 1.786005, 0.960951, 0.313367, -0.757682,
0.659938, -0.47975, -3.893928, -1.605118, -0.139986, -0.14763,
0.540141, 0.333195, -0.389553, 0.287989, -0.958841, -1.519531,
1.007101), V4 = c(-0.361506, 2.153539, 0.234122, -0.834998, -2.523112,
0.20499, -0.834853, 1.726389, -1.869661, 2.228162, 0.666489,
1.467406, 2.40152, -1.101377, -0.387113, -1.327597, -0.937625,
-0.182271, -0.09114, -0.673998, 0.383973, 1.55024, 0.674394,
-0.481227, 1.040994, 2.177336, -0.583843, -0.153885, 0.812392,
0.735835, -2.07859, -0.524823, -3.351206, -0.747727, -0.557665,
-1.596109, -1.404547, -1.833884, -0.025611, 0.802139, 1.297884,
2.994646, 1.255196, 0.920525, -0.349523, 1.043583, 1.479011,
0.541615, -2.163346, -1.535878, 2.00765, -0.585901, -1.824482,
1.14577, 0.591435, 0.329577, -0.221499, 0.493533, -0.984807,
-2.654546, 0.439111, -1.25226, -0.402279, 1.518193, 2.456611,
-1.719398, -1.697259, -0.880927, 1.159705, -0.392843, 0.536198,
-0.139343, 1.776115, 0.344273, 3.12348, 1.694898, 0.485456, 2.665234,
-0.467816, -0.458101, -1.79804, 2.138535, -0.866406, 1.50125,
-2.65885, -0.637633, -0.018684, -2.027927, 1.030387, 0.917763,
0.41602, 1.128201, 2.185718, 0.217378, 0.514869, -1.733343, -0.338825,
1.940684, 0.591259, 2.138413, 2.107243, 0.566856, -0.484852,
-0.853589, 2.499803, -0.714785, 1.062504, 0.061486, -1.272706,
-2.90416, -0.405459, 0.17335, 0.387281, 1.087928, -1.795636,
-0.551264, 0.09469, -1.998665, -1.378574, 0.079998, -1.676905,
-0.702503, 1.92683, -2.637585, 0.090149, -0.04573, -0.641857,
-1.716956, 0.303054, 1.621159, 2.572309, -1.210901, 1.828363,
-0.760034, 0.661693, -1.379957, 1.59612, 2.060168, 2.06495, -1.772661,
0.317698, -0.903428, -1.032261, 1.192174, 0.186236, 1.052416,
-2.688891, -0.802909, 1.86419, -1.835254, 0.686677, 2.465911,
2.307037, -2.234012, 1.227203, -1.760837, 0.98407, 0.880176,
0.393787, 0.878344, 0.549396, -0.360593, -1.386719, 1.363704,
-1.809569, -0.600563, -2.569991, 1.070413, 0.420392, 0.627375,
-0.279389, 1.763639, -0.594351, 1.35102, 0.62509, 0.330779, -1.726877,
0.99704, 0.64701, -1.104629, -0.760793, -2.567698, 0.439025,
-0.279507, 0.3951, 0.57622, -1.026556, -1.212282, 1.144642, -1.029494,
-1.972576, -1.672493, -1.503409, -1.039095, -0.132923, -0.118914,
-0.474545, 0.688723, -2.308719, 0.876329, 1.732321, 0.67163,
1.652487, 0.071473, -0.82509, 2.364368, -0.144275, -0.720321,
-0.840882, 0.316885, -1.057262, -1.34956, -1.283467, -1.11518,
-1.282595, -0.266296, 1.679084, 0.224238, 0.154736, 0.220683,
-1.65338, -1.829616, 1.454862, 0.128591, -0.033498, -0.823086,
-1.567124, 0.173384, -0.70898, 2.226841, -0.323646, 0.263807,
-2.473033, 2.224398, -1.652402, 0.203274, 2.117579, 1.161847,
-2.896897, 0.013486, -1.68413, 1.056995, -2.138419, -0.357342,
0.737772, 0.777444, -0.301737, 1.284651, 2.955764, -2.303592,
2.741645, 0.076438, -1.330154, 1.327701, -0.077075, -0.521419,
-1.520787, 1.206069, -0.055585, -0.065962, -2.97842, 1.225396,
2.153955, 3.113891, -1.138127, 0.052275, 0.991408, 0.898722,
2.513629, 1.329631, -0.412092, 0.436224, -0.916384, 0.484885,
1.361833, -2.552604, -2.277766, 0.747028, -1.192513, -0.213789,
-1.617731, -1.116574, -0.721077, -3.505278, 1.409151, -1.283719,
1.463353, -1.683404, -0.017036, -0.769133, 1.500402, -1.026076,
0.86566, 0.082666, 1.875045, 0.367822, 2.848203, 1.454799, 0.957432,
-1.664573, -1.970987, -0.492403, -0.243013, -2.190188, -1.822954,
-1.093807, -1.370761, -0.240209, -0.477082, -1.505378, -1.501953,
-1.957073, -0.682337, -3.034558, 1.087441, 0.833492, -1.509337,
1.23885, -0.362348, -1.484946, -2.464772, -0.417576, -1.580647,
1.562216, 0.808333, -1.346345, -1.031524, -0.207816, 0.865512,
-0.122604, 1.159704, -0.129388, -2.035736, 0.083112, -1.291269,
1.780731, -0.133869, -2.296012, -1.472443, -2.999677, -3.321346,
1.291122, 1.094797, -0.343564, -1.766692, 2.865132, -2.040651,
-0.534015, -0.028625, 0.828753, -2.182248, -0.314304, 1.574801,
-1.014466, 0.849408, -0.001099, -1.368916, 0.021398, -0.16383,
-1.425328, 0.414038, 0.205694, -0.262825, 1.142594, 1.037286,
-0.518907, 0.861418, -1.248322, 1.297296, -1.138445, -0.590527,
-0.04702, -0.518355, 0.4424, -0.277442, -2.777676, 1.061334,
-0.464852, 2.214876, 1.409535, 2.04161, 0.964479, 2.528411, -0.054825,
0.807469, 0.377414, -0.727317, -1.415787, 1.700229, -3.483491,
1.648251, -1.901526, -0.814847, -2.694323, -2.256379, 0.981913,
-0.3584, -0.847093, 0.947202, 0.186538, -0.110697, 0.929445,
1.092743, 2.066371, -0.162629, -0.740705, 0.936188, 0.23528,
-0.405331, -0.656181, 0.884389, -0.17522, 1.481361, 0.526872,
1.04432, 0.061681, 1.194534, 3.362915, -0.221128, 2.024612, -2.480404,
-2.173626, 1.449919, 1.782122, 1.049721, 1.066918, 0.871242,
0.18925, 0.20368, -0.008824, -0.980859, 1.074937, -3.321869,
1.028821, 0.955583, 0.865748, -0.199404, 0.925228, 1.280986,
2.027217, 1.488324, 0.984956, 3.538978, 1.106135, -0.688892,
0.914454, 0.848681, 0.324573, 2.174615, 2.153744, -2.212586,
-2.7721, 0.083282, 0.488709, -2.367683, 1.875926, -0.177688,
-2.246314, -1.382025, -0.852413, -0.363093, 2.614445, 1.075875,
-3.153487, 1.323977, -1.56948, 0.679226, 0.24118, 1.295007, 0.716071,
0.518213, 1.308873, 0.983633, -1.403625, -0.767516, -2.845689,
-2.380598, 0.763115, -2.329148, -2.38366, -2.263894, 0.163185,
1.852498, 2.777837, 0.758054, 0.535244, 1.47475, -0.259414, -0.475542,
-1.886437, 1.069802, 0.527454, -1.960047, 1.195944, 2.879065,
0.773786, 2.062851, -1.792514, 2.216625, 2.259267)), row.names = c(NA,
-500L), class = "data.frame")
'))
names(df) <- c(paste0("u", 1:3), "y")
df[1:3] <- lapply(df[1:3], function(x){ordered(cut(x, 3), labels = 1:3)})
thresh <- tidySEM:::mx_thresholds(df[1:3])

c1 <- mxModel(model = "class1",
              type = "RAM",
              manifestVars = names(df),
              mxPath(from = "one", to = names(df)[1:3], free = FALSE, values = 0),
              mxPath(from = "one", to = names(df)[4], free = TRUE, values = 0),
              mxPath(from = names(df)[1:3], to = names(df)[1:3], free = FALSE, values = 1, arrows = 2),
              mxPath(from = names(df)[4], to = names(df)[4], free = TRUE, values = 1, arrows = 2),
              thresh,
              mxFitFunctionML(vector=TRUE))
c1$expectation$thresholds <- "Thresholds"

c2 <- mxModel(c1,
              name = "class2")

mix_tidysem <- mxModel(model = "mix",
                       c1,
                       c2,
                       mxData(df, type = "raw"),
                       mxMatrix(values=c(1, 0), nrow=1, ncol=2, lbound = 1e-4, free=c(FALSE, TRUE), name="weights"),
                       mxExpectationMixture(paste0("class", 1:2), weights = "weights", scale="sum"),
                       mxFitFunctionML()
)
#dput(res_tidysem$class2$mat_dev$values, file = "clipboard")
c1$mat_dev$values <- structure(c(-0.302926034964045, 2.82909331886401, -0.156445970735619,
                                 2.45771849854658, -0.7972067240314, 3.32008451032839), .Dim = 2:3)
c2$mat_dev$values <- structure(c(-2.81346831932699, 2.97287051561923, -16.0318807337397,
                                 16.2223970956036, -7.36668563619277, 7.53597976150227), .Dim = 2:3)
#dput(res_tidysem$class2$M$values[1,4], file = "clipboard")
c1$S$values[4,4] <- 1.1720109167467
c2$S$values[4,4] <- 0.9371036285639
c1$M$values[1,4] = -1.06960406324529
c2$M$values[1,4] = 0.962237983458882
# c2$mat_dev$lbound[1,] <- -10
# c2$mat_dev$ubound <- c2$mat_dev$lbound
# c2$mat_dev$ubound[,] <- 10

res_tidysem <- mxTryHardOrdinal(mix_tidysem, extraTries = 10)
tmp_tidysem <- class_prob(res_tidysem)

props_tidysem <- suppressWarnings(table_results(res_tidysem, columns=NULL))
fit_tidysem <- table_fit(res_tidysem)

# df_mp <- df
# df_mp[1:3] <- lapply(df_mp[1:3], as.integer)
# res_mp <- mplusObject(VARIABLE = "usevariables are u1-u3 y;
# categorical are u1-u3;
#                         CLASSES = c(2);",
#                       ANALYSIS = "type = MIXTURE;
#                       starts = 500 20",
#             rdata = df_mp,
#             modelout = "test.inp",
#             run = 1L
#             )
# dput(res_mp$results$summaries$LL, file = "clipboard")
# dput(res_mp$results$class_counts$modelEstimated$proportion, file = "clipboard")
# dput(res_mp$results$parameters$unstandardized$est[c(2:7, 10:15)][unlist(list(c(1:6), c(7:12))[order(res_mp$results$class_counts$modelEstimated$proportion)])], file = "clipboard")

test_that("ordinal mixture model works with mx_threshold", {
  expect_equal(-2036.035, fit_tidysem$LL, tolerance = 2)
  expect_equivalent(sort(tmp_tidysem$sum.posterior$proportion),
                    sort(c(0.52532, 0.47468)), tolerance = .02)

  expect_equivalent(sort(pnorm(as.numeric(props_tidysem$est[props_tidysem$matrix == "Thresholds"]))),
                    sort(pnorm(c(-0.477, 5.189, -0.231, 4.807, -1.296, 5.177, -5.473, 0.27,
                                 -15, 0.311, -15, 0.286)))
                    , tolerance = .12) # Note high tolerance!
})

