% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_lineribbon.R
\name{geom_lineribbon}
\alias{geom_lineribbon}
\title{Line + multiple probability ribbon plots (ggplot geom)}
\usage{
geom_lineribbon(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", ..., na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set at the
layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{stat}{The statistical transformation to use on the data for this layer.}

\item{position}{The position adjustment to use for overlapping points on this layer.}

\item{...}{Other arguments passed to \code{\link{layer}}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? \code{NA}, the default, includes if any aesthetics
are mapped. \code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than combining with them. This is
most useful for helper functions that define both data and aesthetics and shouldn't inherit behavior from the
default plot specification, e.g. borders.}
}
\description{
A combination of \code{\link{geom_line}} and \code{\link{geom_ribbon}} with default aesthetics
designed for use with output from \code{\link{point_interval}}.
}
\details{
\code{geom_lineribbon} is a combination version of a \code{\link{geom_line}}, and \code{geom_ribbon} designed for use
with output from \code{\link{point_interval}}. This geom sets some default aesthetics equal to the \code{.lower},
\code{.upper}, and \code{.width} columns generated by the \code{point_interval} family of functions, making them
often more convenient than a vanilla \code{\link{geom_ribbon}} + \code{\link{geom_line}}.

Specifically, \code{geom_lineribbon} acts as if its default aesthetics are
\code{aes(ymin = .lower, ymax = .upper, size = -.width)}.
}
\examples{

library(dplyr)
library(ggplot2)

data_frame(x = 1:10) \%>\%
  group_by_all() \%>\%
  do(data_frame(y = rnorm(100, .$x))) \%>\%
  median_qi(.width = c(.5, .8, .95)) \%>\%
  ggplot(aes(x = x, y = y)) +
  # automatically uses aes(ymin = .lower, ymax = .upper, fill = fct_rev(ordered(.width)))
  geom_lineribbon() +
  scale_fill_brewer()

}
\seealso{
See \code{\link{stat_lineribbon}} for a version that does summarizing of samples into points and intervals
within ggplot. See \code{\link{geom_pointinterval}} / \code{\link{geom_pointintervalh}} for a similar geom intended
for point summaries and intervals. See \code{\link{geom_ribbon}} and \code{\link{geom_line}} for the geoms this is
based on.
}
\author{
Matthew Kay
}
\keyword{manip}
