% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_manual.R
\name{segment_manual}
\alias{segment_manual}
\title{Manually segment a time series}
\usage{
segment_manual(x, tau, ...)
}
\arguments{
\item{x}{A time series}

\item{tau}{a set of indices representing a changepoint set}

\item{...}{arguments passed to \link{seg_cpt}}
}
\value{
A \link{seg_cpt} object
}
\description{
Segment a time series by manually inputting the changepoint set
}
\details{
Sometimes you want to see how a manually input set of changepoints performs.
This function takes a time series and a changepoint detection set as inputs
and returns a \link{seg_cpt} object representing the segmenter.
Note that by default \code{\link[=fit_meanshift_norm]{fit_meanshift_norm()}} is used to fit the model and
\code{\link[=BIC]{BIC()}} is used as the penalized objective function.
}
\examples{
# Segment a time series manually
segment_manual(CET, tau = c(84, 330))
segment_manual(CET, tau = NULL)

}
