% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unianova.R
\name{unianova}
\alias{unianova}
\title{Compute one-way ANOVAs}
\usage{
unianova(data, group_var, ..., descriptives = FALSE, post_hoc = FALSE)
}
\arguments{
\item{data}{a \link[tibble:tibble-package]{tibble}}

\item{group_var}{group variable (column name)}

\item{...}{test variables (column names). Leave empty to compute ANOVAs for
all numeric variables in data.}

\item{descriptives}{a logical indicating whether descriptive statistics (mean
& standard deviation) for all group levels should be added to the returned
tibble. Defaults to \code{FALSE}.}

\item{post_hoc}{a logical indicating whether post-hoc tests (Tukey's HSD)
should be computed. Results of the post-hoc test will be added in a list
column of result tibbles.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Computes one-way ANOVAS for one group variable and specified test variables.
If no variables are specified, all numeric (integer or double) variables are
used.
}
\examples{
WoJ \%>\% unianova(employment, autonomy_selection, autonomy_emphasis)
WoJ \%>\% unianova(employment)
WoJ \%>\% unianova(employment, descriptives = TRUE, post_hoc = TRUE)

}
\seealso{
Other ANOVA: \code{\link{compute_aov}}
}
\concept{ANOVA}
