% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.R
\name{crosstab}
\alias{crosstab}
\title{Crosstab variables}
\usage{
crosstab(
  data,
  col_var,
  ...,
  add_total = FALSE,
  percentages = FALSE,
  chi_square = FALSE
)
}
\arguments{
\item{data}{a \link[tibble:tibble-package]{tibble}}

\item{col_var}{Independent (column) variable.}

\item{...}{Dependent (row) variables.}

\item{add_total}{Logical indicating whether a 'Total' column should be
computed. Defaults to \code{FALSE}.}

\item{percentages}{Logical indicating whether to output column-wise
percentages instead of absolute values. Defaults to \code{FALSE}.}

\item{chi_square}{Logical indicating whether a Chi-square test should be computed.
Test results will be reported via message(). Defaults to \code{FALSE}.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Computes contingency table for one independent (column) variable and one or
more dependent (row) variables.
}
\examples{
WoJ \%>\% crosstab(reach, employment)
WoJ \%>\% crosstab(reach, employment, add_total = TRUE, percentages = TRUE, chi_square = TRUE)

}
\seealso{
Other categorical: 
\code{\link{tab_frequencies}()}
}
\concept{categorical}
