% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{center_scale}
\alias{center_scale}
\title{Center numeric, continuous variables}
\usage{
center_scale(data, ..., name = NULL, overwrite = FALSE)
}
\arguments{
\item{data}{A \link[tibble:tibble-package]{tibble} or a \link{tdcmm} model.}

\item{...}{Numeric variables to be centered. If none are provided, all
numeric columns will be centered.}

\item{name}{Optional name for the new centered variable when a single
variable is provided. By default, the name will be the original variable
name suffixed with \verb{_centered}.}

\item{overwrite}{Logical. If \code{TRUE}, it overwrites the original variable(s)
with the centered values. If \code{FALSE} (default), a new variable(s) is created.}
}
\value{
A \link{tdcmm} model with the centered variable(s).
}
\description{
This function centers the specified numeric columns or all numeric columns
if none are specified. A centered scale has a mean of 0.0.
}
\examples{
WoJ \%>\% dplyr::select(autonomy_emphasis) \%>\% center_scale(autonomy_emphasis)
WoJ \%>\% center_scale(autonomy_emphasis, name = "my_centered_variable")
WoJ \%>\% center_scale(overwrite = TRUE)
WoJ \%>\%
  center_scale(autonomy_emphasis) \%>\%
  tab_frequencies(autonomy_emphasis, autonomy_emphasis_centered)
}
\seealso{
Other scaling: 
\code{\link{categorize_scale}()},
\code{\link{dummify_scale}()},
\code{\link{minmax_scale}()},
\code{\link{recode_cat_scale}()},
\code{\link{reverse_scale}()},
\code{\link{setna_scale}()},
\code{\link{z_scale}()}
}
\concept{scaling}
