% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_html}
\alias{export_html}
\title{Export the workflow plot as HTML}
\usage{
export_html(g, file, ...)
}
\arguments{
\item{g}{Plot rendered by \code{\link{visualize_graph}}.}

\item{file}{File to save HTML into.}

\item{...}{Additional parameters for \code{\link[visNetwork]{visSave}}.}
}
\value{
HTML file path
}
\description{
Export the workflow plot as HTML
}
\examples{
file_html <- tempfile(fileext = ".html")
flow <- system.file("cwl/sbg/workflow/gatk4-wgs.json", package = "tidycwl") \%>\% read_cwl_json()
if (rmarkdown::pandoc_available("1.12.3")) {
  get_graph(
    flow \%>\% parse_inputs(),
    flow \%>\% parse_outputs(),
    flow \%>\% parse_steps()
  ) \%>\%
    visualize_graph() \%>\%
    export_html(file_html)
}
}
