% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.bayes.R
\name{.fit.bayes}
\alias{.fit.bayes}
\title{Bayesian generalized linear regression for \code{tidyfit}}
\usage{
\method{.fit}{bayes}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.

A 'tibble'.
}
\description{
Fits a Bayesian regression on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}} and \code{\link{classify}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}

The function provides a wrapper for \code{arm::bayesglm}. See \code{?bayesglm} for more details.

\strong{Implementation}

\emph{No implementation notes}
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns

# Stand-alone function
fit <- m("bayes", Return ~ ., data)
fit

# Within 'regress' function
fit <- regress(data, Return ~ ., m("bayes"), .mask = c("Date", "Industry"))
coef(fit)


}
\references{
Gelman A, Su Y (2021). \emph{arm: Data Analysis Using Regression and Multilevel/Hierarchical Models}. R package version 1.12-2, \url{https://CRAN.R-project.org/package=arm}.
}
\seealso{
\code{\link{.fit.glm}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
