% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_at_if.R
\name{all_dt}
\alias{all_dt}
\alias{at_dt}
\alias{if_dt}
\title{Wise mutate or summarise with "all-at-if"}
\usage{
all_dt(data, .func, .funcs, ...)

at_dt(data, .at, .func, .funcs, ...)

if_dt(data, .if, .func, .funcs, ...)
}
\arguments{
\item{data}{A data.frame}

\item{.func}{Main function name,either "mutate(_dt)" or "summarise(_dt)"}

\item{.funcs}{Function to be run within each column, should return a value or
vectors with same length.}

\item{...}{Parameters to be passed to parameter *.funcs*.}

\item{.at}{Variables to select, could use regular expression or numeric/character
vector.}

\item{.if}{Conditional function to select columns.
When starts with `-`(minus symbol), return the negative columns.}
}
\value{
A data.table
}
\description{
In \pkg{dplyr}, there are functions like \code{mutate_at},
\code{mutate_if} and \code{mutate_all}, as well as \code{summarise_at},
\code{summarise_if} and \code{summarise_all}. Here we provide a simple way
to do both in \code{all_dt},\code{at_dt} and \code{if_dt}.
}
\details{
Always return the columns with their original names after \code{mutate} or
\code{summarise}.
}
\examples{

# all_
all_dt(iris[,-5],mutate_dt,scale)
all_dt(iris[,-5],mutate,scale)
all_dt(iris[,-5],summarise,max)
all_dt(iris[,-5],summarise,min)

# at_
iris \%>\% at_dt("Se",mutate,scale)
iris \%>\% at_dt(1:3,mutate,scale)
iris \%>\% at_dt(c("Petal.Length"),mutate,scale,center = FALSE)

 # if_
 iris \%>\%
   if_dt(is.double,mutate_dt,scale,center = FALSE)
  ## support minus symbol to select negative conditions
 iris \%>\%
   if_dt(-is.factor,mutate_dt,scale,center = FALSE)
 iris \%>\%
   if_dt(is.factor,mutate,as.character)
 iris \%>\%
   if_dt(is.numeric,summarise,max,na.rm = TRUE)
}
