% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_dt.R
\name{set_dt}
\alias{set_dt}
\alias{mutate_ref}
\title{Fast operations of data.table by reference}
\usage{
set_dt(
  data,
  col_order = NULL,
  order_by = NULL,
  order_dirc = 1L,
  old_name = NULL,
  new_name = NULL,
  fill_cols = NULL,
  fill_type = "down",
  fill_value = NA
)

mutate_ref(data, ..., by)
}
\arguments{
\item{data}{A data.frame}

\item{col_order}{(Optional) Character vector of the new column name ordering.
May also be column numbers. This parameter will pass to "neworder" parameter
in \code{\link[data.table]{setcolorder}}.}

\item{order_by}{(Optional) A character vector of column names by which to order.
This parameter will pass to "cols" parameter in \code{\link[data.table]{setorder}}.}

\item{order_dirc}{(Optional) An integer vector with only possible values of 1 and -1,
corresponding to ascending and descending order. This parameter will pass to
"order" parameter in \code{\link[data.table]{setorder}}. Default uses 1.}

\item{old_name}{(Optional) When \code{new_name} is provided,
character names or numeric positions of column names to change.
This parameter will pass to "old" parameter in
\code{\link[data.table]{setnames}}.}

\item{new_name}{(Optional) It can be a function or the new column names.
This parameter will pass to "new" parameter in
\code{\link[data.table]{setnames}}.}

\item{fill_cols}{(Optional)
Numeric or character vector specifying columns to be updated.}

\item{fill_type}{(Optional)
Character, one of "down", "up" or "replace". Defaults to "down".}

\item{fill_value}{(Optional)
Numeric or integer, value to be used to fill when
\code{fill_type=="replace"}. Defaults to \code{NA}.}

\item{...}{List of variables or name-value pairs of modifications functions.}

\item{by}{Mutate by which group(s)?}
}
\value{
The input is modified by reference, and returned (invisibly)
so it can be used in compound statements.
}
\description{
Combination of \code{set*} functions provided by \pkg{data.table}.
 This is memeroy efficient because no copy is made at all.
}
\details{
The \code{set_dt()} will first set any data.frame to a data.table,
then rename, fill NAs, arrange row order, arrange column order. If you
want to do the operation in another order, use it separately in multiple
\code{set_dt} functions in the desired order.

The \code{mutate_ref()} will first set any data.frame to a data.table,
then mutate values by reference.
}
\examples{

# set_dt
x = 1:10
x[c(1:2, 5:6, 9:10)] = NA
dt = data.table(v1=x, v2=lag_dt(x)/2, v3=lead_dt(x, 1L)/2)
dt
set_dt(dt,new_name = c("A","B","C"),fill_cols = names(dt),
        order_by = "A",order_dirc = -1,col_order = c("B","A","C"))
dt

 # mutate_ref
 copy(iris) -> a
 # never use pipe(\%>\%) for the `mutate_ref` function
 mutate_ref(a,one = 1,two = 2)
 a
}
\seealso{
\code{\link[data.table]{setcolorder}},
\code{\link[data.table]{setorder}}, \code{\link[data.table]{setnames}},
\code{\link[data.table]{setnafill}}
}
