% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unite.R
\name{unite_dt}
\alias{unite_dt}
\title{Unite multiple columns into one by pasting strings together}
\usage{
unite_dt(data, united_colname, ..., sep = "_", remove = TRUE, na.rm = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{united_colname}{The name of the new column, string only.}

\item{...}{A selection of columns. If want to select all columns,
pass "" to the parameter. See example.}

\item{sep}{Separator to use between values.}

\item{remove}{If \code{TRUE}, remove input columns from output data frame.}

\item{na.rm}{If \code{TRUE}, missing values would be merged into \code{NA},
otherwise \code{NA} is treated as character "NA". This is different from
\pkg{tidyr}.}
}
\description{
Convenience function to paste together multiple columns into one.
Analogous to \code{tidyr::unite}.
}
\examples{
df <- expand.grid(x = c("a", NA), y = c("b", NA))
df

# Treat missing value as character "NA"
df \%>\% unite_dt("z", x:y, remove = FALSE)
# Treat missing value as NA
df \%>\% unite_dt("z", x:y, na.rm = TRUE, remove = FALSE)
df \%>\%
  unite_dt("xy", x:y)

# Select all columns
iris \%>\% unite_dt("merged_name","")
}
\seealso{
\code{\link[tidyr]{unite}},\code{\link[tidyfst]{separate_dt}}
}
