% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowwise.R
\name{rowwise_mutate}
\alias{rowwise_mutate}
\alias{rowwise_summarise}
\title{Computation by rows}
\usage{
rowwise_mutate(.data, ...)

rowwise_summarise(.data, ...)
}
\arguments{
\item{.data}{A data.table}

\item{...}{Name-value pairs of expressions}
}
\value{
A data.table
}
\description{
Compute on a data frame a row-at-a-time.
This is most useful when a vectorised function doesn't exist.
Only mutate and summarise are supported so far.
}
\examples{
# without rowwise
df <- data.table(x = 1:2, y = 3:4, z = 4:5)
df \%>\% mutate(m = mean(c(x, y, z)))
# with rowwise
df <- data.table(x = 1:2, y = 3:4, z = 4:5)
df \%>\% rowwise_mutate(m = mean(c(x, y, z)))


# # rowwise is also useful when doing simulations
params = fread(" sim n mean sd
  1  1     1   1
  2  2     2   4
  3  3    -1   2")

params \%>\%
  rowwise_summarise(sim,z = rnorm(n,mean,sd))

}
\seealso{
\code{\link[dplyr]{rowwise}}
}
