% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_closest.R
\name{genome_join_closest}
\alias{genome_join_closest}
\alias{genome_inner_join_closest}
\alias{genome_left_join_closest}
\alias{genome_right_join_closest}
\alias{genome_full_join_closest}
\alias{genome_semi_join_closest}
\alias{genome_anti_join_closest}
\title{Join intervals on chromosomes in data frames, to the closest partner}
\usage{
genome_join_closest(x, y, by = NULL, mode = "inner",
  distance_column_name = NULL, max_distance = Inf, select = "all")

genome_inner_join_closest(x, y, by = NULL, ...)

genome_left_join_closest(x, y, by = NULL, ...)

genome_right_join_closest(x, y, by = NULL, ...)

genome_full_join_closest(x, y, by = NULL, ...)

genome_semi_join_closest(x, y, by = NULL, ...)

genome_anti_join_closest(x, y, by = NULL, ...)
}
\arguments{
\item{x}{A dataframe.}

\item{y}{A dataframe.}

\item{by}{A character vector with 3 entries which are used to match the chromosome, start and end column.
For example: \code{by=c("Chromosome"="chr", "Start"="start", "End"="end")}}

\item{mode}{One of "inner", "full", "left", "right", "semi" or "anti".}

\item{distance_column_name}{A string that is used as the new column name with the distance.
If \code{NULL} no new column is added.}

\item{max_distance}{The maximum distance that is allowed to join 2 entries.}

\item{select}{A string that is passed on to \code{IRanges::distanceToNearest}, can either be
all which means that in case that multiple intervals have the same distance all are reported, or
arbitrary which means in that case one would be chosen at random.}

\item{...}{Additional arguments parsed on to genome_join_closest.}
}
\value{
The joined dataframe of \code{x} and \code{y}.
}
\description{
Join intervals on chromosomes in data frames, to the closest partner
}
\examples{

library(dplyr)

x1 <- data.frame(id = 1:4, bla=letters[1:4],
                 chromosome = c("chr1", "chr1", "chr2", "chr2"),
                 start = c(100, 200, 300, 400),
                 end = c(150, 250, 350, 450))

x2 <- data.frame(id = 1:4, BLA=LETTERS[1:4],
                 chromosome = c("chr1", "chr2", "chr2", "chr1"),
                 start = c(140, 210, 400, 300),
                 end = c(160, 240, 415, 320))
j <- genome_intersect(x1, x2, by=c("chromosome", "start", "end"), mode="both")
print(j)
}
