% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphers.R
\name{morphers}
\alias{morphers}
\alias{to_linegraph}
\alias{to_subgraph}
\alias{to_split}
\alias{to_components}
\alias{to_complement}
\alias{to_local_neighborhood}
\alias{to_dominator_tree}
\alias{to_minimum_spanning_tree}
\alias{to_shortest_path}
\alias{to_bfs_tree}
\alias{to_dfs_tree}
\alias{to_simple}
\alias{to_contracted}
\alias{to_unfolded_tree}
\alias{to_directed}
\alias{to_undirected}
\alias{to_hierarchical_clusters}
\title{Functions to generate alternate representations of graphs}
\usage{
to_linegraph(graph)

to_subgraph(graph, ..., subset_by = NULL)

to_split(graph, ..., split_by = NULL)

to_components(graph, type = "weak")

to_complement(graph, loops = FALSE)

to_local_neighborhood(graph, node, order = 1, mode = "all")

to_dominator_tree(graph, root, mode = "out")

to_minimum_spanning_tree(graph, weights = NULL)

to_shortest_path(graph, from, to, mode = "out", weights = NULL)

to_bfs_tree(graph, root, mode = "out", unreachable = FALSE)

to_dfs_tree(graph, root, mode = "out", unreachable = FALSE)

to_simple(graph)

to_contracted(graph, ..., simplify = TRUE)

to_unfolded_tree(graph, root, mode = "out")

to_directed(graph)

to_undirected(graph)

to_hierarchical_clusters(graph, method = "walktrap", weights = NA, ...)
}
\arguments{
\item{graph}{A \code{tbl_graph}}

\item{...}{Arguments to pass on to \code{\link[=filter]{filter()}}, \code{\link[=group_by]{group_by()}}, or the cluster
algorithm (see \code{\link[igraph:cluster_walktrap]{igraph::cluster_walktrap()}}, \code{\link[igraph:cluster_leading_eigen]{igraph::cluster_leading_eigen()}},
and \code{\link[igraph:cluster_edge_betweenness]{igraph::cluster_edge_betweenness()}})}

\item{subset_by, split_by}{Whether to create subgraphs based on nodes or edges}

\item{type}{The type of component to split into. Either \code{'weak'} or \code{'strong'}}

\item{loops}{Should loops be included. Defaults to \code{FALSE}}

\item{node}{The center of the neighborhood}

\item{order}{The radius of the neighborhood}

\item{mode}{How should edges be followed? \code{'out'} only follows outbound
edges, \code{'in'} only follows inbound edges, and \code{'all'} follows all edges. This
parameter is ignored for undirected graphs.}

\item{root}{The root of the tree}

\item{weights}{Optional edge weights for the calculations}

\item{from, to}{The start and end node of the path}

\item{unreachable}{Should the search jump to a node in a new component when
stuck.}

\item{simplify}{Should edges in the contracted graph be simplified? Defaults
to \code{TRUE}}

\item{method}{The clustering method to use. Either \code{'walktrap'}, \code{'leading_eigen'}, or \code{'edge_betweenness'}}
}
\value{
A list of \code{tbl_graph}s
}
\description{
These functions are meant to be passed into \code{\link[=morph]{morph()}} to create a temporary
alternate representation of the input graph. They are thus not meant to be
called directly. See below for detail of each morpher.
}
\section{Functions}{
\itemize{
\item \code{to_linegraph}: Convert a graph to its line graph. When unmorphing node
data will be merged back into the original edge data. Edge data will be
ignored.

\item \code{to_subgraph}: Convert a graph to a single subgraph. \code{...} is evaluated
in the same manner as \code{filter}. When unmorphing all data in the subgraph
will get merged back.

\item \code{to_split}: Convert a graph into a list of separate subgraphs. \code{...}
is evaluated in the same manner as \code{group_by}. When unmorphing all data in
the subgraphs will get merged back, but in the case of \code{split_by = 'edges'}
only the first instance of node data will be used (as the same node can be
present in multiple subgraphs).

\item \code{to_components}: Split a graph into its separate components. When
unmorphing all data in the subgraphs will get merged back.

\item \code{to_complement}: Convert a graph into its complement. When unmorphing
only node data will get merged back.

\item \code{to_local_neighborhood}: Convert a graph into the local neighborhood around a
single node. When unmorphing all data will be merged back.

\item \code{to_dominator_tree}: Convert a graph into its dominator tree based on a
specific root. When unmorphing only node data will get merged back.

\item \code{to_minimum_spanning_tree}: Convert a graph into its minimum spanning tree/forest.
When unmorphing all data will get merged back.

\item \code{to_shortest_path}: Limit a graph to the shortest path between two nodes.
When unmorphing all data is merged back.

\item \code{to_bfs_tree}: Convert a graph into a breath-first search tree based on
a specific root. When unmorphing only node data is merged back.

\item \code{to_dfs_tree}: Convert a graph into a depth-first search tree based on
a specific root. When unmorphing only node data is merged back.

\item \code{to_simple}: Collapse parallel edges and remove loops in a graph.
When unmorphing all data will get merged back

\item \code{to_contracted}: Combine multiple nodes into one. \code{...}
is evaluated in the same manner as \code{group_by}. When unmorphing all
data will get merged back.

\item \code{to_unfolded_tree}: Unfold a graph to a tree or forest starting from
multiple roots (or one), potentially duplicating nodes and edges.

\item \code{to_directed}: Make a graph directed in the direction given by from and
to

\item \code{to_undirected}: Make a graph undirected

\item \code{to_hierarchical_clusters}: Convert a graph into a hierarchical clustering based on a grouping
}}

\examples{
# Compute only on a subgraph of every even node
create_notable('meredith') \%>\%
  morph(to_subgraph, seq_len(graph_order()) \%\% 2 == 0) \%>\%
  mutate(neighbour_count = centrality_degree()) \%>\%
  unmorph()
}
