% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pull_station_number}
\alias{pull_station_number}
\title{Convenience function to pull station number from tidyhydat functions}
\usage{
pull_station_number(.data)
}
\arguments{
\item{.data}{A table of data}
}
\value{
A vector of station_numbers
}
\description{
This function mimics \code{dplyr::pull} to avoid having to always type
dplyr::pull(STATION_NUMBER). Instead we can now take advantage of autocomplete. 
This can be used with \code{realtime_} and \code{hy_} functions.
}
\examples{
\dontrun{

hy_stations(prov_terr_state_loc = "PE") \%>\%
 pull_station_number() \%>\%
 hy_annual_instant_peaks()
}

}
